<?php
namespace backend\filters;
use yii;
use yii\filters\AccessRule;

class AccessRule1 extends AccessRule
{
	protected function matchRole($user)
	{
		if(empty($this->roles))
		{
			return true;
		}

		foreach($this->roles as $role)
		{
			if($role === '?')
			{
				if(Yii::$app->user->isGuest)
				{
					return true;
				}
			}elseif($role==='@')
			{
				if(!Yii::$app->user->isGuest)
				{
					return true;
				}
			}elseif($role === 'admin')
			{
				if(!Yii::$app->user->isGuest && Yii::$app->user->identity->role==='admin')
				{
					return true;
				}
			}elseif($role === 'Staff')
			{
				if(!Yii::$app->user->isGuest && Yii::$app->user->identity->role==='Staff')
				{
					return true;
				}
			}elseif($role === 'Agent')
			{
				if(!Yii::$app->user->isGuest && Yii::$app->user->identity->role==='Agent')
				{
					return true;
				}
			}
		}
		return false;
	}
}


?>