<?php

namespace backend\models;

use Yii;
use backend\models\User;

/**
 * This is the model class for table "authorizers".
 *
 * @property int $id
 * @property int $department
 * @property int $authorizer
 * @property int $cid
 */
class Authorizers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'authorizers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['department', 'authorizer', 'cid'], 'required'],
            [['department', 'authorizer', 'cid'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'department' => 'Department',
            'authorizer' => 'Authorizer',
            'cid' => 'Cid',
        ];
    }

      function getName()
    {
        $name=User::findOne($this->authorizer);
        return ucwords($name->last_name.' '.$name->first_name);
    }
}
