<?php
namespace backend\models;

use yii\base\Model;
use common\models\User;
use backend\models\Departments;

/**
 * Signup form
 */
class ClientSignupForm extends Model
{
    public $username;
    public $email;
    public $password;
    public $first_name;
    public $last_name;
    public $cid;
    // public $position;
    public $department;
    // public $position_label;
    public $role;
    public $place;
    public $shop_id;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            ['username', 'trim'],
            ['username', 'required'],
            ['username', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This username has already been taken.'],
            ['username', 'string', 'min' => 2, 'max' => 255],

            ['cid','required'],

            ['first_name', 'trim'],
            ['last_name', 'trim'],

            ['role', 'required'],
            ['role', 'string', 'min'=>2, 'max' => 200],

            ['first_name', 'string', 'min'=>3, 'max' =>150],
            ['last_name', 'string', 'min'=>3, 'max' =>150],
            ['first_name','required'],
            ['last_name','required'],

            ['email', 'trim'],
            ['email', 'required'],
            ['email', 'email'],
            ['shop_id', 'forshop','skipOnEmpty'=>false],
            ['email', 'string', 'max' => 255],
            ['role', 'my_unique'],
            ['email', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This email address has already been taken.'],

            ['password', 'required'],
            ['password', 'string', 'min' => 6],

            // ['position', 'required'],
            ['department', 'required'],
            // ['position_label', 'required'],
            ['place', 'required'],
            ['place', 'my_unique_group']

          
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    // public function signup()
    // {
    //     if (!$this->validate()) {
    //         return null;
    //     }
        
    //     $user = new User();
    //     $user->username = $this->username;
    //     $user->email = $this->email;        
    //     $user->setPassword($this->password);
    //     $user->generateAuthKey();        
        
    //     return $user->save() ? $user : null;
    // }


     public function clientsignup()
    {
        
        if (!$this->validate()) {
            return null;
        }
        
          if ($this->validate()) {
        $user = new User();
        $user->username = $this->username;
        $user->email = $this->email;
        $user->cid = $this->cid;
        $user->first_name = $this->first_name;
        $user->last_name = $this->last_name;
        $user->shop_id = $this->shop_id;
        $user->setPassword($this->password);
        $user->generateAuthKey();
        // $user->position=$this->position;
        $user->department=$this->department;
        // $user->position_label=$this->position_label;
        $user->role=$this->role;
        $user->place=$this->place;
        $user->save(false);

          // the following three lines were added:
        $auth = \Yii::$app->authManager;
        $authorRole = $auth->getRole($this->role);
        $auth->assign($authorRole, $user->getId());
         // return $user->save() ? $user : null;
        return $user;
    }
     return null;
    }

     public function my_unique($attribute,$params)
    {
       
        //$checked=User::model()->find('role=:ba and cid=:sh',array(':ba'=>$this->role,':sh'=>$this->cid));
        $checked=User::find()->where(['role'=>$this->role])->andWhere(['cid'=>$this->cid])->andWhere(['!=','role','App User'])->andwhere(['place'=>1])->one();
        if($checked!=null && $this->place==1)
        {
             $this->addError('role',
            'You can only have one user with '.$this->role.' Role who is group head');
        }
        // else if(!empty($this->phoneno) && $this->stdcode=='')
           //  {
           //      $this->addError('stdcode','Please enter STD number');
           //  }
    }

    public function my_unique_group($attribute,$params)
    {
       
        //$checked=User::model()->find('role=:ba and cid=:sh',array(':ba'=>$this->role,':sh'=>$this->cid));
        $checked=User::find()->where(['cid'=>$this->cid])->andWhere(['=','place',1])->andWhere(['department'=>$this->department])->one();
       // $checked=User::find()->where(['place'=>$this->place])->andWhere(['cid'=>$this->cid])->andWhere(['!=','place','Group Member'])->andWhere(['department'=>$this->department])->one();
        if($checked!=null && $this->place==1)
        {
             if($this->place==1){ $place='Group head'; }
             $this->addError('place',
            'You can only have one user with '.$place.' Status for '.Departments::findOne($this->department)->department_name.' department');
        }
        // else if(!empty($this->phoneno) && $this->stdcode=='')
           //  {
           //      $this->addError('stdcode','Please enter STD number');
           //  }
    }

     public function forshop($attribute,$params)
    {
        if($this->department==1 && $this->shop_id==NULL)
        {
            $this->addError('shop_id',
            'Users on the shop Workgroup must enter a shop_id');
        }      
    }
}
