<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "client".
 *
 * @property int $id
 * @property string $client_name
 * @property string $email
 * @property string $website
 * @property string $client_address
 * @property string $phone
 * @property int $industry
 * @property string $created_at
 * @property string $updated_at
 * @property int $owner
 * @property int $stamp
 */
class Clients extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'client';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['client_name', 'client_address', 'industry'], 'required'],
            [['client_name', 'client_address'], 'string'],
            [['industry','owner','stamp'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['email'], 'string', 'max' => 150],
            [['website'], 'string', 'max' => 100],
            [['phone'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'client_name' => 'Client Name',
            'email' => 'Email',
            'website' => 'Website',
            'client_address' => 'Client Address',
            'phone' => 'Phone',
            'industry' => 'Industry',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
