<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "rooms".
 *
 * @property int $id
 * @property int $room_type
 * @property string $room_range
 * @property int $cid
 * @property int $total_rooms
 * @property string $rooms
 * @property int $shop_id
 */
class Rooms extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'rooms';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['room_type', 'room_range', 'cid', 'total_rooms', 'rooms', 'shop_id'], 'required'],
            [['room_type', 'cid', 'total_rooms', 'shop_id'], 'integer'],
            [['room_range', 'rooms'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'room_type' => 'Room Type',
            'room_range' => 'Base Number',
            'cid' => 'Cid',
            'total_rooms' => 'Total Rooms',
            'rooms' => 'Rooms',
            'shop_id' => 'Shop ID',
        ];
    }

   
}
