<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "rooms2".
 *
 * @property int $id
 * @property int $cid
 * @property string $room_number
 * @property double $price
 * @property int $type
 * @property string $name
 * @property int $booked
 * @property int $status
 * @property int $shop_id
 */
class Rooms2 extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'rooms2';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'room_number', 'price', 'type', 'shop_id'], 'required'],
            [['cid', 'type', 'booked', 'status', 'shop_id'], 'integer'],
            [['price'], 'number'],
            [['room_number'], 'string', 'max' => 7],
            [['name'], 'string', 'max' => 200],
            // [['room_number'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'room_number' => 'Room Number',
            'price' => 'Price',
            'type' => 'Type',
            'name' => 'Name',
            'booked' => 'Booked',
            'status' => 'Status',
            'shop_id' => 'Shop ID',
        ];
    }
}
