<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Rooms2;

/**
 * Rooms2Search represents the model behind the search form of `backend\models\Rooms2`.
 */
class Rooms2Search extends Rooms2
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'type', 'booked', 'status', 'shop_id'], 'integer'],
            [['room_number', 'name'], 'safe'],
            [['price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Rooms2::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => $this->cid,
            'price' => $this->price,
            'type' => $this->type,
            'booked' => $this->booked,
            'status' => $this->status,
            'shop_id' => $this->shop_id,
        ]);

        $query->andFilterWhere(['like', 'room_number', $this->room_number])
            ->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }
}
