<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\models\Inventory;
use yii\helpers\ArrayHelper;
use backend\models\Shops;


/* @var $this yii\web\View */
/* @var $model backend\models\Rooms2 */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="rooms2-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>$cid])->label(false) ?>

    <?= $form->field($model, 'room_number')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'price')->textInput() ?>    

     <?php echo $form->field($model, 'type')->dropDownList(
   ArrayHelper::map(Inventory::find()->where(['cid'=>$cid])->andWhere(['shop_type'=>3])->all(),'id','name'),['prompt'=>'']) ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true,'readonly'=>'readonly']) ?>

    <?= $form->field($model, 'booked')->hiddenInput()->label(false) ?>

    <?= $form->field($model, 'status')->hiddenInput()->label(false) ?>

     <?php echo $form->field($model, 'shop_id')->dropDownList(
   ArrayHelper::map(Shops::find()->where(['cid'=>$cid])->all(),'id','name'),['prompt'=>''])->label('Select Sales point') ?>

   

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
