<?php
namespace frontend\components;
use Yii;
use yii\base\Component;
use yii\web\Controller;
use yii\web\Response;
use frontend\modules\hr\models\TempDeductions;
use frontend\modules\hr\models\Allowances;
use frontend\modules\hr\models\ClientAccount;


class ExportExcelComponent extends component{

    public $data;
    public $headers;    

    function buildExcel($headers,$data,$date1,$date2,$client)
    {        
         $this->headers = $headers;
         $this->data = $data;
         $records = [];
         $from = date('jS F Y',strtotime($date1));
         $to = date('jS F Y',strtotime($date2));
         $location = \frontend\modules\hr\models\ClientUnits::findOne($data[0]['location'])->unit_name;
         $customer = ClientAccount::find()->where(['id'=>$client])->one()->client_name;
         
         $pay_period = "$customer ($location) PAYROLL FOR $from to $to";

         array_push($records,['',$pay_period]);
         array_push($records, []);
         array_push($records, $this->headers);
         
         if($records!=null){ 

        $amount=0;
        // load all allowances from allowance table. allowances in this table are in percentage not actual values
        $groups=Allowances::find()->where(['cid'=>Yii::$app->user->identity->cid,'allowance_group'=>1])->all();
       
       // loop to get total sum of all allowances in percentage
        foreach($groups as $group)
        {
            $amount+=Allowances::find()->where(['id'=>$group->id,'cid'=>Yii::$app->user->identity->cid])->one()->percentage;
        } 

        $i = 1;
         foreach($this->data as $da)
         {        

            $dpension = 0;
            $dpayee = 0;


            // get deductions and calculate real pay (amount earned by hourly rate multiplied by number of hours)
            list($dat,$real_pay)=$this->real($date1,$date2,$da,$client); 

            $bht=(($amount/100)*$da['gross_pay']);       

            // get totals for pay components like housing, transport, basic etc
            list($basic,$transport,$housing,$others)=$this->pay_break($da,$amount,$bht);

            // push all payroll data in to one variable ie the records array
            $records = $this->local_build($records,$da,$basic,$housing,$transport,$others,$dat,$bht,$i);
            $i++;
         }
     }
        // return compiled csv pay data for each staff
         return $records;
    }


    function real($date1,$date2,$da,$client)
    {
         if(isset($date1) && isset($date2) && $date1!='today')
            {
                $dat=TempDeductions::find()->where(['staff_id'=>$da['staff_id'],'client'=>$client,'cid'=>Yii::$app->user->identity->cid])->andwhere(['>=','substr(month, 1,10)',substr($date1,0,7)])->andWhere(['<=','substr(month, 1,10)',substr($date2,0,7)])->one();   

                 $real_pay=($da['gross_pay']/$da['shift'])*(floor($da['work_hours']/60) );
             }else{
                 $dat=TempDeductions::find()->where(['staff_id'=>$da['staff_id'],'client'=>$client,'cid'=>Yii::$app->user->identity->cid,'substr(month,1,7)'=>date('Y-m')])->one();   

                 $real_pay=($da['gross_pay']/$da['shift'])*(floor($da['work_hours']/60) );
             }

             return [$dat,$real_pay];
    }


    function pay_break($da,$amount,$bht)
    {       

         $basic = (\frontend\modules\hr\models\Allowances::findOne(['cid'=>Yii::$app->user->identity->cid,'allowance_name'=>'BASIC'])->percentage*$da['gross_pay'])/100; 

         $transport = (\frontend\modules\hr\models\Allowances::findOne(['cid'=>Yii::$app->user->identity->cid,'allowance_name'=>'TRANSPORT'])->percentage*$da['gross_pay'])/100;

         $housing = (\frontend\modules\hr\models\Allowances::findOne(['cid'=>Yii::$app->user->identity->cid,'allowance_name'=>'HOUSING'])->percentage*$da['gross_pay'])/100;

         $others = (\frontend\modules\hr\models\Allowances::findOne(['cid'=>Yii::$app->user->identity->cid,'allowance_name'=>'OTHERS'])->percentage*$da['gross_pay'])/100;

         return [$basic,$transport,$housing,$others];
    }


    function local_build($records,$da,$basic,$housing,$transport,$others,$dat,$bht,$i)
    {
        $theClient = ClientAccount::findOne($da['dclient']);
       
        array_push($records, [$i,$da['surname'],ucwords(\frontend\modules\hr\models\Designate::find()->where(['id'=>$da['designation']])->one()->designation_name),number_format($basic,2),number_format($transport,2),number_format($housing,2),number_format($others,2),number_format($da['gross_pay'],2),$da['shift'],floor($da['work_hours']/60),$dpension=$theClient->pension ? $theClient->pension : 0,$dpayee=$theClient->payee ? ($theClient->payee) : 0,number_format($dat->advance,2),number_format($dat->surcharge,2),number_format(($dpension+$dpayee+$dat->surcharge+$dat->advance),2),number_format($da['gross_pay']-($dpension+$dpayee+$dat->surcharge+$dat->advance),2)]);
        
        return $records;
    }


    public static function Csv($records,$date1,$date2,$location)
    {        
       
        $data = json_decode($records);       

        // $filename = 'component_summary.csv';   
        $loc = \frontend\modules\hr\models\ClientUnits::findOne($location)->unit_name;
        $file_name = $loc.' PAYROLL '.date('jS F Y',strtotime($date1)).' to '.date('jS F Y',strtotime($date2));

        $filename = $file_name.'.csv'; 

        // file creation
        $file = fopen($filename,"w");

        foreach ($data as $line){
         fputcsv($file,$line);
        }

        fclose($file);

        // download
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=".$filename);
        header("Content-Type: application/csv; "); 

        readfile($filename);

        // deleting file
        unlink($filename);

    }
    
}
?>