<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log','MyGlobalClass'],
    'controllerNamespace' => 'frontend\controllers',
    'name'=>'Stack',
    'layout'=>'column2',
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-frontend',
        ],
        'mike' => [
        'class' => 'frontend\components\Mycomponent',
        ],
         'bar' => [
        'class' => 'frontend\components\Barcomponent',
        ],
        'wash' => [
        'class' => 'frontend\components\Laundrycomponent',
        ],
        'frank' => [
        'class' => 'frontend\components\Mycart'],
        'MyGlobalClass'=>[
        'class'=>'backend\components\MyGlobalClass'
     ],
     'exportExcel' => [
            'class' => 'frontend\components\ExportExcelComponent',
        ],
     // 'check' => [
     //    'class' => 'frontend\components\SecurityCheck',
     //    ],
     'response' => [
            'formatters' => [
                'html' => [
                    'class' => 'yii\web\HtmlResponseFormatter',
                ],
                'pdf' => [
                    'class' => 'robregonm\pdf\PdfResponseFormatter',
                ],
            ]
        ],
     'authManager' => [
            'class' => 'yii\rbac\DbManager',
            // uncomment if you want to cache RBAC items hierarchy
            // 'cache' => 'cache',
          //  'defaultRoles' => ['guest', 'user'],
        ],
        //    'cart' => [
        //     'class' => 'yii2mod\cart\Cart',
        //     // you can change default storage class as following:
        //     'storageClass' => [
        //         'class' => 'yii2mod\cart\storage\DatabaseStorage',
        //         // you can also override some properties 
        //         'deleteIfEmpty' => true
        //     ]
        // ],
         'cart' => [
            'class' => 'yz\shoppingcart\ShoppingCart',
            'cartId' => 'my_application_cart',
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the frontend
            'name' => 'advanced-frontend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        /*
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
            ],
        ],
        */
    ],
     'modules' => [
        'hr' => [
            'class' => 'frontend\modules\hr\human_resources',
        ],
        'retails' => [
            'class' => 'frontend\modules\retails\retail',
        ],
    ],
    'params' => $params,
];


/*
    # nationality add nations dropdown
personal details
educational details
    # institution type add institution types done
    garantor
    employment detils
d
    # locations
    # employment_type
    # designation / designate
    # cadre
    # section
payment details
allowances




NEW TABLES

allowances
cadre
educational details
employment details
employment type
guarantor
locations
nationality
past employment details
payment details
personal details
section

*/