<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Boq;
use frontend\models\Stores;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\Clients;
use yii\helpers\Html;

use yii\filters\AccessControl;


/**
 * BoqController implements the CRUD actions for Boq model.
 */
class BoqController extends Controller
{
    /**
     * {@inheritdoc}
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }


     public function behaviors()
    {
        return [
              'access' => [
            'class' => AccessControl::className(),
            'rules' => [                         
              
                //  [
                //     'allow' => true,
                //     'actions' => ['docket','save_docket','utilize','dock_details'],
                //     'roles' => ['Production Manager'],
                // ],
                  [
                    'allow' => true,
                    'actions' => ['list','create','update','delete','saveboq','deletet'],
                    'roles' => ['Client Admin','Production Manager'],
                ],
                   [
                    'allow' => true,
                    'actions' => ['delete','deletet'],
                    'roles' => ['admin'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['dedit','dview',
                    'index','view','getitem2','addtocart2','remove_byid2','update_quantity2'],  
                    'roles' => ['@']                 
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

     /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Lists all Boq models.
     * @return mixed
     */
    public function actionIndex($id)
    {
      
        return $this->render('index', [
        'id'=>$id,           
        ]);
    }

    /**
     * Displays a single Boq model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }


     public function actionGetitem2()
    {

          ob_start();
         $item=Yii::$app->request->post('item_name'); 
        $id=Yii::$app->request->post('id'); 
       
         if(!empty($item))
         {

     
        $items=Stores::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->all();
       // var_dump($items);
         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice2('<?php echo $it->id; ?>','<?php echo $id; ?>')"><?= ucwords($it->name).' - '.ucwords($it->particulars) ?></span> 
            <?php
        }
           }       
    
    }



    public function actionAddtocart2()
    {
         ob_start();
         $id=Yii::$app->request->post('item_id'); 
         $id2=Yii::$app->request->post('id2'); 
        // access the cart from "cart" subcomponent

       $cart = new  \yz\shoppingcart\ShoppingCart();

      
                $model = Stores::findOne($id);
            
        $cart->put($model, 1);

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne($id2);
     

        ?>


       <h1 style="text-align:center;">Bill of Quantity</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>


</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Qunatity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().','.$id2.')']) ?>
        </td>   
        
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>','<?php echo $id2; ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>




</table>
</div>
        <?php
    

    }



    public function actionRemove_byid2()
    {
        $id=Yii::$app->request->post('id');
        $id2=Yii::$app->request->post('id2');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne($id2);
        ob_start();
        
     ?>

         <h1 style="text-align:center;">Bill of Quantity</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>


</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Qunatity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().','.$id2.')']) ?>
        </td>   
        
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>','<?php echo $id2; ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>




</table>


        <?php
    }


     public function actionUpdate_quantity2()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $id2=Yii::$app->request->post('id2');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);


         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne($id2);
        ob_start();
    ?>
  <h1 style="text-align:center;">Bill of Quantity</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>


</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Qunatity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().','.$id2.')']) ?>
        </td>   
        
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>','<?php echo $id2; ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>




</table>
</div>
        <?php
    

}



public function actionSaveboq()
{
    $id=Yii::$app->request->post('id');
    $product=Yii::$app->request->post('product');
    $estimate=Yii::$app->request->post('estimate');
    $transaction_id=time().rand(1,9);
//echo $product; die;
    $check=Boq::find()->where(['product_name'=>$product])->andWhere(['=','cid',$id])->one();
    if($check!=null)
    {
?>

<script type="text/javascript">
alert('Convertion table for manufacturing this product already Exists');

</script>
<?php
die;
    }

     $cart = new  \yz\shoppingcart\ShoppingCart();      

    $bills = $cart->getPositions();

    foreach($bills as $bill)
    {
        $bob=new Boq();

        $bob->product_name=$product;
        $bob->cid=$id;
        $bob->created_at=date('Y-m-d');
        $bob->quantity=$bill->getQuantity();
        $bob->material=$bill->id;
        $bob->estimate=$estimate;
        $bob->transaction_id=$transaction_id;
        if(!$bob->save())
        {
            var_dump($bob->getErrors()); die;
        }    

    }
    $cart->removeAll();
        ?>
<script type="text/javascript">
alert('Bacth successfuly created!');
</script>

<?php
}



public function actionList()
{
   $list=Boq::find()->where(['=','cid',Yii::$app->user->identity->cid])->groupBy('transaction_id')->all();
    return $this->render('list',['list'=>$list,'id'=>Yii::$app->user->identity->cid]);
}

    /**
     * Creates a new Boq model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Boq();

        if ($model->load(Yii::$app->request->post())) {
            $model->created_at=date('Y-m-d');
            // var_dump($model); die;
            // $model->items=json_encode($model->items);
            $at=array();
            foreach($model->items as $mod)
            {
                $at[]=array('material'=>$mod['material'],'quantity'=>$mod['quantity']);
            }
            $model->items=json_encode($at);
            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Boq model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Boq model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Boq model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Boq the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Boq::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionDview($id)
    {
        $model=Boq::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$id])->all();
        return $this->render('dview',['model'=>$model]);
    }

    public function actionDedit($id)
    {
        return $this->render('dedit');
    }

    public function actionDeletet()
    {
        $tid=Yii::$app->request->get('id');        
        if(Boq::deleteAll(['transaction_id'=>$tid]))
        {
        return $this->redirect(['list']);
    }else{
        die('record was not deleted');
    }
    }
}
