<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Entry;
use frontend\models\EntrySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\Ledger;
use yii\filters\AccessControl;

/**
 * EntryController implements the CRUD actions for Entry model.
 */
class EntryController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
          'access' => [
            'class' => AccessControl::className(),
            'rules' => [        
                [
                    'allow' => true,
                    'actions' => ['update','updateLedger','updateDiscount','update_debit'],  
                    'roles' => ['Client Admin','accounts']                 
                ],
               
                [
                    'allow' => true,
                    'actions' => ['index','view'],  
                    'roles' => ['@']                 
                ],
                //  [
                //     'allow' => true,
                //     'actions' => ['error'],  
                //     'roles' => ['?','@']                 
                // ],
            ],
        ],
        'verbs' => [
            'class' => VerbFilter::className(),
            'actions' => [
                'delete' => ['POST'],
            ],
        ],
    ];
}

    /**
     * Lists all Entry models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new EntrySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Entry model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Entry model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Entry();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Entry model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    // public function actionUpdate($id)
    // {
    //     $model = $this->findModel($id);

    //     if ($model->load(Yii::$app->request->post()) && $model->save()) {
    //         return $this->redirect(['view', 'id' => $model->id]);
    //     }

    //     return $this->render('update', [
    //         'model' => $model,
    //     ]);
    // }

    public function actionUpdate($id) {

        $model = $this->findModel($id);

        $date = substr($model->created_at,0,10);
        if($date<'2023-09-26'){
            die("You are not allowed to update entries posted before ".date('jS F Y',strtotime('2023-09-26')));
        }



        $debit = Entry::find()->where(['transaction_id'=>$transaction_id,'entry_type'=>1])->one();
        $credit = Entry::find()->where(['transaction_id'=>$transaction_id,'entry_type'=>2])->one();
       
       
        $current_discount_value = abs($model->amount);
        $tlink = $model->lid;
        $transaction_id = $model->transaction_id;           
      
       
        if ($model->load(Yii::$app->request->post())) {
            // var_dump($model); die;


            $group = Entry::find()->where(['transaction_id' => $transaction_id])->all();
           

            $transaction = Yii::$app->db->beginTransaction();
            try {
           
// we get current value of amount looping over $group below just to get the positive or negative sign beside the number as this screws up trial balance if not consistent
// $m = g->amount/abs($g->amount). this gives -1 or +1
// then we multiply by the new value of $m by $model->amount to make sure we have the appropriate sign of - or + beside the number; $m isnt included in the actual code. just used it for description

            foreach ($group as $g) {
                $chart = \frontend\models\Charts::findOne($g->chart_account);
                $g->amount = $this->setAmount($model->amount,$chart->to_increase,$g->entry_type);
                // $g->amount = $model->amount == null ? null : $g->amount/abs($g->amount)*$model->amount;
                $g->details = $model->details == null ? null : $model->details;
                $g->entry_group = $chart->atype;
                $g->account_group = $chart->account_group;
                // $g->payee = $model->payee == null ? null : $model->payee;
                // $g->transaction_type = $model->transaction_type == null ? null : $model->transaction_type;
                $g->created_at = $model->created_at;
                if(!$g->save())
                {
                    // var_dump($g->getErrors()); die;
                    throw new \Exception('Could not save entry');
                }
            }            



            if($model->dsource=='d')
            {
             // update corresponding ledger entry
            $this->updateDiscount($transaction_id,$model->amount,$model->dsource,$current_discount_value,$tlink);
            }else{
                 // update corresponding ledger entry
                $this->updateLedger($transaction_id,$model->amount,$model->dsource,$current_discount_value);
            }


             $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

            return $this->redirect(['view', 'id' => $model->id, 'debit'=>$debit,'credit'=>$credit]);
        }     

       

        return $this->render('update', [
            'model' => $model,'debit'=>$debit,'credit'=>$credit
        ]);
    }
    
    //
    
    // set negative or positve sign for amount
    
    function setAmount($amount,$dir,$type){
        $amount = ($amount == null || $amount==0) ? 0 : $amount;
        $amount = abs($amount);
        // type 1 is debit transaction and dir 2 is normal credit balance
       // posting against the debit side for an account head whose normal balance is a credit
        // when and account with normal debit balance has negative value we post to the credit side
        // when and account with normal credit balance has negative value we post to the debit side
        if($type==1 && $dir==2)
         {
            $amount= ($amount*-1);
        }
        // type 2 is credit transaction and dir 1 is normal debit balance
        // posting against the credit side for an account head whose normal balance is a debit
        // when and account with normal debit balance has negative value we post to the credit side
        if($type==2 && $dir==1)
        {
           $amount= ($amount*-1);
        }
        
        return $amount;
    }

    // update debit
    public function actionUpdate_debit(){

         $transaction_id = Yii::$app->request->post('tid');
         $account = Yii::$app->request->post('account');
         $dc = Yii::$app->request->post('dc');

         $done = 1;


         if($dc==1)
         {
            $deb = Entry::find()->where(['transaction_id'=>$transaction_id,'entry_type'=>1])->one();
         }

         if($dc==2)
         {
            $deb = Entry::find()->where(['transaction_id'=>$transaction_id,'entry_type'=>2])->one();
         }

            $deb->chart_account=(int)$account;
            if(!$deb->save()){
                $done = 2;
            }

            echo $done;

    }



    // update ledger amount
    public function updateLedger($tid,$amount,$source,$current_discount_value)
    {
        $leg = Ledger::find()->where(['transaction_id'=>$tid,'cid'=>Yii::$app->user->identity->cid])->one();


        // this if statment was introduced because of having to deal with journel entry updates when discounts are involved
        
            if($leg->amount_paid>0){
                $leg->amount_paid = abs($amount);
            }
             if($leg->credit>0){
                $leg->credit = abs($amount);
            }
             if($leg->debit>0){
                $leg->debit = abs($amount);
            }
                   
        
        if(!$leg->save())
        {
            throw new \Exception('Could not update ledger');
        }
    }


    // update the discount   


     public function updateDiscount($tid,$amount,$source,$current_discount_value,$tlink)
    {
        $leg = Ledger::find()->where(['transaction_id'=>$tlink,'cid'=>Yii::$app->user->identity->cid])->one();
        $amount = abs($amount);
        
        // this if statment was introduced because of having to deal with journel entry updates when discounts are involved        
           
        $difference = abs($current_discount_value-$amount);
                if($current_discount_value>$amount){
                    echo $difference;
                    $leg->credit += abs($difference);
                }else{                   
                     $leg->credit -= abs($difference);                    
                }
                 // die;  
        
        if(!$leg->save())
        {
            throw new \Exception('Could not save to ledger');
        }
    }

    /**
     * Deletes an existing Entry model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die('no allowed');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Entry model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Entry the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Entry::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionReverse($tid) {

        $debit = Entry::find()->where(['transaction_id' => $tid, 'entry_type' => 1])->one();
        $credit = Entry::find()->where(['transaction_id' => $tid, 'entry_type' => 2])->one();

        $transaction = Yii::$app->db->beginTransaction();
        try {
            
            // $this->audit($debit,$credit);

            if (!$debit->delete()) {
                throw new \Exception("Error Processing Request");
            }

            if (!$credit->delete()) {
                throw new \Exception("Error Processing Request");
            }

            $transaction->commit();

        } catch (\Exception $e) {
            $transaction->rollBack();
            throw $e;
        } catch (\Throwable $e) {
            $transaction->rollBack();
            throw $e;
        }

        return $this->redirect(['journal']);

    }


    function audit($debit,$credit){
            $audit = new \app\models\AuditTrail;
            $audit->amount = abs($debit->amount);
            $audit->staff_id = Yii::$app->user->identity->id;
            $audit->created_at = date('Y-m-d');
            $audit->details = "Reversed journal entry";
            $audit->debit_account = $debit->chart_account;
            $audit->credit_account = $credit->chart_account;
            $audit->debit_title = \app\models\Charts::findOne($debit->chart_account)->title;
            $audit->credit_title = \app\models\Charts::findOne($credit->chart_account)->title;
            if (!$audit->save()) {
                throw new \Exception("Error Processing Request");
            }
    }
}
