<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Sales;
use frontend\models\SearchSales;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\Inventory;
use backend\models\Clients;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\models\Requisitions;
use frontend\models\Stores;
use backend\models\Departments;
use frontend\models\Notifications;
use frontend\models\Messages;
use yii\filters\AccessControl;
use backend\models\Transfers;
use frontend\models\Customers;
use backend\models\User;
use frontend\models\Productions;
use frontend\models\Shops;
use frontend\models\Dels;
use frontend\models\Discounts;
/**
 * SalesController implements the CRUD actions for Sales model.
 */

date_default_timezone_set('Africa/Lagos');
// error_reporting(E_ALL);

class SalesController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
          'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','delete','update','findModel','store','getitem','getitem2',
                    'addtocart','addtocart2','allcart','checkout','checkout2','clearcart','notecount','rejcount',
                    'attencount','messagecount','sumcount','update_quantity','clearcart2','update_quantity2',
                    'remove_byid','remove_byid2','remove_byid3','sales_report','getitem3',
                    'addtocart3','update_quantity3','clearcart3','update_description3',
                    'update_price3','checkout3','readit','getitemc','getitem3p','addtocart3p',
                    'checkout22','getitem30','addtocart30','update_quantity30','remove_byid30','checkout30','revscount',
                    'revstcount','diskcount','update_quantity3p','remove_byid3p','pendingcount','pendingcount2','addvat','addcharge'],
                    'roles' => ['@'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Sales models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchSales();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Sales model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Sales model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Sales();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Sales model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Sales model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Sales model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return Sales the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Sales::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionStore()
    {
        // $cart = \Yii::$app->cart->getPositions();
      //  var_dump($cart); die;
        $cart = new  \yz\shoppingcart\ShoppingCart();
        if(!$cart->getIsEmpty())
        {
            $cart->RemoveAll();
        }
       
       return $this->render('store');
    }

    public function actionGetitem()
    {

         $item=Yii::$app->request->post('item_name'); 
         if(!empty($item))
         {
        $items=Inventory::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['shop'=>Yii::$app->user->identity->shop_id])->andWhere(['!=','quantity',0])->andWhere(['!=','price',0])->all();
        $show='';
       // var_dump($items);
        foreach($items as $it)
        {
            
            $show.='<span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice('.$it->id.')">'.ucwords($it->name).' - '.ucfirst($it->description).'</span>'; 
            
            
        }
        \Yii::$app->response->data=$show;
    }
    }


    public function actionGetitemc()
    {

         ob_start();
         $itemp=Yii::$app->request->post('item_name');
         $industry=Yii::$app->request->post('ind'); 
         if(!empty($itemp))
         {
        $itemso=Customers::find()->where(['like','name',$itemp])->andWhere(['cid'=>Yii::$app->user->identity->cid])->limit(5)->all();
        $show='';
       // var_dump($items);
        foreach($itemso as $ito)
        {
            
            // $show.='<span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="gump('.$ito->name.')">'.$ito->name.'</span>'; 
           ?>
           <!-- switched add_name to add_nameX to solve morris royal issue -->
<span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_name('<?php echo $ito->name; ?>','<?= $ito->id ?>','<?= $industry ?>')"><?= $ito->name ?></span> 
           <?php 
            
        }
        \Yii::$app->response->data=$show;
    }
    }


    public function actionGetitem2()
    {

          ob_start();
         $item=Yii::$app->request->post('item_name'); 
         $dsender=Yii::$app->request->post('dsender'); 
       //  $dtype=Yii::$app->request->post('dtype'); 
         // var_dump($dtype); die;
         if(!empty($item))
         {
           if(Yii::$app->user->identity->role=='Store Manager')
           {

              $items=Transfers::find()->where(['like','item_name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['reciever_id'=>$dsender])->orderBy('id','asc')->all();
       // var_dump($items);
         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice2('<?php echo $it->id; ?>')"><?= $it->item_name ?></span> 
            <?php
        }

           }else{ 
                  $items=Stores::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->all();
       // var_dump($items);

         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice2('<?php echo $it->id; ?>')"><?= $it->name ?></span> 
            <?php
        }
           }        
    }
    }



    public function actionGetitem30()
    {

          ob_start();
         $item=Yii::$app->request->post('item_name'); 
         $dsender=Yii::$app->request->post('dsender'); 
       //  $dtype=Yii::$app->request->post('dtype'); 
         // var_dump($dtype); die;
         if(!empty($item))
         {


        $items=Stores::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->all();
       // var_dump($items);
         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice30('<?php echo $it->id; ?>')"><?= $it->name.' - '.$it->particulars ?></span> 
            <?php
        }     
       
        }
    }


     public function actionGetitem3p()
    {

          ob_start();
         $item=Yii::$app->request->post('item_name'); 
         $dsender=Yii::$app->request->post('dsender'); 
       //  $dtype=Yii::$app->request->post('dtype'); 
         // var_dump($dtype); die;
         if(!empty($item))
         {

           if(Yii::$app->user->identity->role=='Store Manager')
           {

              $items=Productions::find()->where(['like','item_name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->limit(5)->all();
       // var_dump($items);
         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice3p('<?php echo $it->item_id; ?>')"><?= $it->item_name ?></span> 
            <?php
        }

           }else{
                  $items=Productions::find()->where(['like','item_name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->all();
       // var_dump($items);
         foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice3p('<?php echo $it->item_id; ?>')"><?= $it->item_name ?></span> 
            <?php
        }
           }
      
   

     
       
    }
    }

    public function actionGetitem3()
    {

          ob_start();
         $item=Yii::$app->request->post('item_name'); 
         if(!empty($item))
         {
        $items=Stores::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id','asc')->all();
       // var_dump($items);
        foreach($items as $it)
        {
            ?>
            <span style="background-color:#ccc; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_to_invoice3('<?php echo $it->id; ?>')"><?= $it->name." - ".ucfirst(substr($it->particulars,0,30)) ?></span> 
            <?php
        }
    }
    }


   public function actionAddtocart()
    {
         $id=Yii::$app->request->post('item_id'); 
        // access the cart from "cart" subcomponent
        $cart = new  \yz\shoppingcart\ShoppingCart();        

        $model = Inventory::findOne($id);

        if($model->countable==1){
        if($cart->getcount()>0)
        { // open (1) first check if the shopping cart has any items in it
            if($pot=$cart->getPositionById($id)){ // open (2) if an entry exists in the cart for an item with the specified id go ahead to check quantities in comment line below this one
        if($model->quantity>=($pot->getQuantity()+1)) // check if quantity in inventory table is equal to or greater than quantity already in cart position plus one which is being added
        { 
            $cart->put($model, 1); // if the quantity in the database table is able to meet the request add it to the cart at that position if it is 
        }else{ // else if its not enough to meet the addition request then move to the lines below and display a javascript alert with the available quantity in the alert message 
                ?>
        <script type="text/javascript">
alert('Insufficient Quantity for '+"<?= $model->name; ?>"+' Only ('+<?= $model->quantity; ?>+') left'); // this is the alert message here
        </script>
    <?php
        } 
    }else{  // else for if no entry in cart with specified id
    $cart->put($model, 1); } // close (2) if an entry does not exist with the specified id in the shopping cart move straight down to this point and add the new item to the cart since it never existed in the cart before
}else{
    $cart->put($model, 1); 
} // final close for (1)
}else{
 $cart->put($model, 1);    
}
        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

       //  $selected_text=$_POST['selected_text'];
       // $selected_id=$_POST['selected_id'];       
       // $model= new Requisitions();

       // $resource_type=Tasks::findOne($selected_id);
     
      

       // $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       // $flow_id=$flo->id;
       // $full_flow=$flo->int_workflow;
       
       // $flow_array=explode(',', $flo->int_workflow);
       // $start_flow=$flow_array[0];

       // $instrument_array=explode(',', $flo->instrument);
       // $instrument=$instrument_array[0];

       $this->invoice($all_items,$client,$cart);



        
    }



    public function actionAddtocart2()
    {
          ob_start();
         $id=Yii::$app->request->post('item_id'); 
        // access the cart from "cart" subcomponent
         $dname=0;
       $cart = new  \yz\shoppingcart\ShoppingCart();

        if(Yii::$app->user->identity->role=='Store Manager')
            {
                $model = Transfers::find()->where(['=','id',$id])->one();
                $dname=1;
              /// echo "this is id ". $id; var_dump($model); die($model);
            }else{
                $model = Stores::findOne($id);
            }
        // insert beings
            if($dname==1){ $name=$model->item_name; }else{ $name=$model->name; }
        if($cart->getcount()>0)
        { // open (1) first check if the shopping cart has any items in it
            if($pot=$cart->getPositionById($id)){ // open (2) if an entry exists in the cart for an item with the specified id go ahead to check quantities in comment line below this one
        if($model->quantity>=($pot->getQuantity()+1)) // check if quantity in inventory table is equal to or greater than quantity already in cart position plus one which is being added
        { 
            $cart->put($model, 1); // if the quantity in the database table is able to meet the request add it to the cart at that position if it is 
        }else{ // else if its not enough to meet the addition request then move to the lines below and display a javascript alert with the available quantity in the alert message 
                ?>
        <script type="text/javascript">
alert('Insufficient Quantity for '+"<?= $name; ?>"+' Only ('+<?= $model->quantity; ?>+') left'); // this is the alert message here
        </script>
    <?php
        } 
    }else{  // else for if no entry in cart with specified id
    $cart->put($model, 1); } // close (2) if an entry does not exist with the specified id in the shopping cart move straight down to this point and add the new item to the cart since it never existed in the cart before
}else{
    $cart->put($model, 1); 
} // final close for (1)

        // inset ends
       

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

       //  $selected_text=$_POST['selected_text'];
       // $selected_id=$_POST['selected_id'];       
       // $model= new Requisitions();

       // $resource_type=Tasks::findOne($selected_id);
     
      

       // $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       // $flow_id=$flo->id;
       // $full_flow=$flo->int_workflow;
       
       // $flow_array=explode(',', $flo->int_workflow);
       // $start_flow=$flow_array[0];

       // $instrument_array=explode(',', $flo->instrument);
       // $instrument=$instrument_array[0];

        ?>

<?php  if(Yii::$app->user->identity->role!='Store Manager'){ ?>

       <h1 style="text-align:center;">Store Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">STORE VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>
        <?php
    }else{
        // if department is store == 6
?>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">STORE VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php //echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php //echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->item_name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

<?php
    }

    }


    public function actionAddtocart30()
    {
          ob_start();
         $id=Yii::$app->request->post('item_id'); 
        // access the cart from "cart" subcomponent

       $cart = new  \yz\shoppingcart\ShoppingCart();

     
                $model = Stores::findOne($id);
            // start

        if($cart->getcount()>0)
        { // open (1) first check if the shopping cart has any items in it
            if($pot=$cart->getPositionById($id)){ // open (2) if an entry exists in the cart for an item with the specified id go ahead to check quantities in comment line below this one
        if($model->quantity>=($pot->getQuantity()+1)) // check if quantity in inventory table is equal to or greater than quantity already in cart position plus one which is being added
        { 
            $cart->put($model, 1); // if the quantity in the database table is able to meet the request add it to the cart at that position if it is 
        }else{ // else if its not enough to meet the addition request then move to the lines below and display a javascript alert with the available quantity in the alert message 
                ?>
        <script type="text/javascript">
alert('Insufficient Quantity for '+"<?= $model->name; ?>"+' Only ('+<?= $model->quantity; ?>+') left'); // this is the alert message here
        </script>
    <?php
        } 
    }else{  // else for if no entry in cart with specified id
    $cart->put($model, 1); } // close (2) if an entry does not exist with the specified id in the shopping cart move straight down to this point and add the new item to the cart since it never existed in the cart before
}else{
    $cart->put($model, 1); 
} // final close for (1)
                // stop
        

        $all_items = $cart->getPositions();
      

        $client=Clients::findOne(Yii::$app->user->identity->cid);


?>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">ORDER VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php //echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php //echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity30('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id30('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

<?php
    

    }

    // start 3p here

     public function actionAddtocart3p()
    {
          ob_start();
         $id=Yii::$app->request->post('item_id'); 
        // access the cart from "cart" subcomponent

       $cart = new  \yz\shoppingcart\ShoppingCart();

        if(Yii::$app->user->identity->role=='Store Manager')
            {
                $model = Productions::find()->where(['=','item_id',$id])->one();
              /// echo "this is id ". $id; var_dump($model); die($model);
            }else{
                $model = Productions::find()->where(['=','item_id',$id])->one();
            }
        
        if($cart->getcount()>0)
        { // open (1) first check if the shopping cart has any items in it
            if($pot=$cart->getPositionById($model->id)){ // open (2) if an entry exists in the cart for an item with the specified id go ahead to check quantities in comment line below this one
        if($model->quantity>=($pot->getQuantity()+1)) // check if quantity in inventory table is equal to or greater than quantity already in cart position plus one which is being added
        { 
            $cart->put($model, 1); // if the quantity in the database table is able to meet the request add it to the cart at that position if it is 
        }else{ // else if its not enough to meet the addition request then move to the lines below and display a javascript alert with the available quantity in the alert message 
                ?>
        <script type="text/javascript">
alert('Insufficient Quantity for '+"<?= $model->item_name; ?>"+' Only ('+<?= $model->quantity; ?>+') left'); // this is the alert message here
        </script>
    <?php
        } 
    }else{  // else for if no entry in cart with specified id
    $cart->put($model, 1); } // close (2) if an entry does not exist with the specified id in the shopping cart move straight down to this point and add the new item to the cart since it never existed in the cart before
}else{
    $cart->put($model, 1); 
} // final close for (1)

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

  

        ?>

<?php  
        // if department is store == 6
?>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">PRODUCTION VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php //echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php //echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->item_name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity3p('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id3p('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

<?php
    

    }

    // remove by id 3p under here

     public function actionRemove_byid3p()
    {
          ob_start();
        
 $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
?>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">PRODUCTION VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php //echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php //echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->item_name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity3p('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id3p('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

<?php
    

    }
    // update production transfer quantity

    public function actionUpdate_quantity3p()
    {          
         

      $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $model=Productions::findOne($id);
        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        if($model->quantity>=$quantity){
        $cart->update($pot,$quantity);
    }

    if($model->quantity<$quantity)
    {
        ?>
    <script type="text/javascript">
    alert("Insufficient Quantity for "+"<?= $model->item_name ?>"+". Only ("+<?= $model->quantity; ?>+") left");
    </script>
        <?php
    }
         $all_items = $cart->getPositions();
       

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">PRODUCTION VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php //echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php //echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->item_name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity3p('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

<?php
    

    }

    public function actionAddtocart3()
    {
         ob_start();
         $id=Yii::$app->request->post('item_id'); 
        // access the cart from "cart" subcomponent
       $cart = new  \yz\shoppingcart\ShoppingCart();

        $model = Stores::findOne($id);
        $cart->put($model, 1);

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

       //  $selected_text=$_POST['selected_text'];
       // $selected_id=$_POST['selected_id'];       
       // $model= new Requisitions();

       // $resource_type=Tasks::findOne($selected_id);
     
      

       // $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       // $flow_id=$flo->id;
       // $full_flow=$flo->int_workflow;
       
       // $flow_array=explode(',', $flo->int_workflow);
       // $start_flow=$flow_array[0];

       // $instrument_array=explode(',', $flo->instrument);
       // $instrument=$instrument_array[0];

        ?>

<h1 style="text-align:center;">Material Purchase List</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>


<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Description</td> <td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ 
        $get = Stores::findOne($all->getid());
    $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textArea('description',$all->particulars,['class'=>'form-control camp','id'=>$all->getid().'description','style'=>'width:250px;','onkeyup'=>'update_description3('.$all->getid().')','autocomplete'=>'off','readonly'=>true]) ?>
        </td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control camp','id'=>$all->getid().'quantity','style'=>'width:50px;','onkeyup'=>'update_quantity3('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= Html::textInput('price',$all->getPrice(),['class'=>'form-control camp','id'=>$all->getid().'price','style'=>'width:100px;','onkeyup'=>'update_price3('.$all->getid().',1)','autocomplete'=>'off']) ?><?= $get->cost_price!=null ? Html::button($get->cost_price,['class'=>'btn btn-primary','onclick'=>'update_price3('.$all->getid().',2)']) : '' ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id3('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="7">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }


      public function actionAllcart()
    {
        $cart = new  \yz\shoppingcart\ShoppingCart();
          $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        ?>
      <h1 style="text-align:center;">Cart</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">INVOICE</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= number_format($all->getPrice(),2) ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="6">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }


    public function actionCheckout()
    {
        
        $flowid=Yii::$app->request->post('flowid'); 
        $instrument=Yii::$app->request->post('instrument'); 
        $status=Yii::$app->request->post('status'); 
        $seen=Yii::$app->request->post('seen'); 
        $cid=Yii::$app->request->post('cid'); 
        $origin=Yii::$app->request->post('origin'); 
        $department=Yii::$app->request->post('department'); 
        $title=Yii::$app->request->post('title'); 
        $task_type=Yii::$app->request->post('task_type');
        $customer_name=Yii::$app->request->post('name');
        $amount_paid=Yii::$app->request->post('amount_paid');
        $narration=Yii::$app->request->post('narration');
        $legs=Yii::$app->request->post('legs');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions();
        

        $sale= new Requisitions();

        $sale->workflow_id=$flowid;
        $sale->cid=$cid;
        $sale->title=$title;
        $sale->originating_department=$department;
        $sale->raised_by=$origin;
        $sale->status=$status;
        $sale->instrument=$instrument;
        $sale->not_seen=$seen;  
        $sale->task_type=$task_type;
        $sale->transaction_id=time().rand(1,9); 
        $sale->legs = $legs;
     
        $use_tid=$sale->transaction_id;
        $item=array();

        foreach($positions as $position)
        {
             $total=$position->getQuantity()*$position->price; 
             $amount=$position->price; 
             $quantity=$position->getQuantity(); 
             $description=$position->description;           
             $item_name=$position->name;
             $id=$position->id;
             if(empty($customer_name))
             {
                 $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$position->item_id,'id'=>$id,'amount_paid'=>$amount_paid,'narration'=>$narration,'shop_id'=>Yii::$app->user->identity->shop_id,'countable'=>$position->countable);
             }else{
                 $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$position->item_id,'customer_name'=>$customer_name,'id'=>$id,'amount_paid'=>$amount_paid,'narration'=>$narration,'shop_id'=>Yii::$app->user->identity->shop_id,'countable'=>$position->countable, 'subject'=>$customer_name,);
             }
           
        }
        // json_encode($response, JSON_UNESCAPED_SLASHES);
       
        if($item[0]['quantity']>0)
        {
            $sale->requested_item=json_encode($item);
            if(!$sale->save())
            {
                var_dump($sale->getErrors()); die;
            }
         }

         $cart->removeAll();
       

        
        $all_items = Requisitions::find()->where(['=','transaction_id',$use_tid])->one();
        $allt=json_decode($all_items->requested_item,true);
        
   

        $client=Clients::findOne(Yii::$app->user->identity->cid);
     $tot=0;
     
     ob_start();
       ?>
<div id="holder" style="width:100%;">
        <h1 style="text-align:center;">Transaction Details</h1>



<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none; padding-left: 20px;">
    <tr>
        <th colspan="3">
                <?= Html::img('@web/assets/logo/mlogo2.jpg', ['alt'=>'Morris Royal logo', 'style'=>'display:block; margin:auto; width:100px; height:auto']);?>
            </th>
    </tr>
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:12px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">INVOICE</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $all_items->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:left;">Being Payment for: <span style="font-weight:normal"><?php echo ucfirst($allt[0]['narration']); ?></span></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Sale Rep: <span style="font-weight:normal;"><?php echo ucfirst(User::findOne($all_items->raised_by)->username);  ?></span></td>
<td colspan="1" style="">Customers Name: <?php echo ucwords(Customers::findOne($allt[0]['customer_name'])->name)  ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td>Price</td><td>Total</td> </tr>
    <?php foreach($allt as $all){ ?>
    <tr >
        <td style="width:10%;">S/NO.</td>
        <td><?= $all['item_name'] ?></td>
        <td><?= $all['quantity'] ?></td>   
        <td style="width:20%;"><?= number_format($all['amount'],2) ?></td>
        <td><del>N</del><?php $tot+=$all['total']; echo  number_format($all['total'],2) ?></td>
    </tr>
    <?php } ?>
<tr style="font-weight:bold;">
        <td></td>
        
        <td></td>
        <td></td>
        <td>Total</td>
        <td><del>N</del><?= number_format($tot,2) ?></td>
    </tr>

    <tr style="font-weight:bold;">
        <td></td>
        
        <td></td>
        <td></td>
        <td>Amount Paid</td>
        <td><del>N</del><?= number_format($all['amount_paid'],2) ?></td>
    </tr>

<tr>


            <td colspan="5">
<span style="font-weight:bold;">Amount in words:</span> <?= Yii::$app->Formatter->asSpellout($tot) ?> Naira Only.
</td>
    </tr>
 
</table>

</div>

        
<div style="text-align:right;"><?= Html::button('Print Invoice',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?></div>


       <?php

     //  ob_get_clean(); 
     //ob_flush();
    }


    public function actionCheckout2()
    {
        $flowid=Yii::$app->request->post('flowid'); 
        $instrument=Yii::$app->request->post('instrument'); 
        $status=Yii::$app->request->post('status'); 
        $seen=Yii::$app->request->post('seen'); 
        $cid=Yii::$app->request->post('cid'); 
        $origin=Yii::$app->request->post('origin'); 
        $department=Yii::$app->request->post('department'); 
        $title=Yii::$app->request->post('title'); 
        $task_type=Yii::$app->request->post('task_type');

        // $dtype=Yii::$app->request->post('dtype');
        $dsender=Yii::$app->request->post('dsender');
        $narration=Yii::$app->request->post('narration');
        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions();
         // var_dump($all_items);
         ob_start();

        $sale= new Requisitions();

        $sale->workflow_id=$flowid;
        $sale->cid=$cid;
        $sale->title=$title;
        $sale->originating_department=$department;
        $sale->raised_by=$origin;
        $sale->status=$status;
        $sale->instrument=$instrument;
        $sale->not_seen=$seen; 
        $sale->task_type=$task_type; 
        $sale->transaction_id=time().rand(1,9);        
        $sale->dsender_id=$dsender; 
        // total, amount, details, quantity, item_name, 
        // $price=array();
        // $amount=array();
        // $total=array();
        // $quantity=array();
        // $description=array();

        $k=0;
        $item=array();
if(Yii::$app->user->identity->role!='Store Manager')
{
        foreach($positions as $position)
        {
             $total=$position->getQuantity()*$position->price; 
             $amount=$position->price; 
             $quantity=$position->getQuantity(); 

             $description=$position->description;           
             $item_name=$position->name;
             $item_id=$position->id;
            $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$item_id,'narration'=>$narration,'countable'=>$position->countable);
        }
    }else{
         foreach($positions as $position)
        {
             $total=$position->getQuantity()*$position->price; 
             $amount=0; 
             $quantity=$position->getQuantity(); 

             $description='';           
             $item_name=$position->item_name;
             $item_id=$position->item_id;
            $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$item_id,'narration'=>$narration);
        }
    }
        //json_encode($response, JSON_UNESCAPED_SLASHES);
        if($item[0]['quantity']>0)
        {
             $sale->requested_item=json_encode($item);

            if(!$sale->save())
            {
               
                var_dump($sale->getErrors()); 
            }else{
 $k=1;
                $cart->removeAll();
                if($k==1){
                ?>
<script type="text/javascript">
$("#3").hide();
alert('Resource Transfer Transaction Initialized'); 
</script>
                <?php
            }
                // $this->redirect(['requisitions/create']);
            }
            
        } 
    }


    // work to do

     public function actionCheckout30()
    {
        $flowid=Yii::$app->request->post('flowid'); 
        $instrument=Yii::$app->request->post('instrument'); 
        $status=Yii::$app->request->post('status'); 
        $seen=Yii::$app->request->post('seen'); 
        $cid=Yii::$app->request->post('cid'); 
        $origin=Yii::$app->request->post('origin'); 
        $department=Yii::$app->request->post('department'); 
        $title=Yii::$app->request->post('title'); 
        $task_type=Yii::$app->request->post('task_type');

        // $dtype=Yii::$app->request->post('dtype');
        
        $flow=Yii::$app->request->post('flow');
        $shop=Yii::$app->request->post('shop');
        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions();
         // var_dump($all_items);
         ob_start();

        $sale= new Requisitions();

        $sale->workflow_id=$flowid;
        $sale->cid=$cid;
        $sale->title=$title;
        $sale->originating_department=$department;
        $sale->raised_by=$origin;
        $sale->status=$status;
        $sale->instrument=$instrument;
        $sale->not_seen=$seen; 
        $sale->task_type=$task_type; 
        $sale->transaction_id=time().rand(1,9);        
       
        // total, amount, details, quantity, item_name, 
        // $price=array();
        // $amount=array();
        // $total=array();
        // $quantity=array();
        // $description=array();
        $item=array();

        foreach($positions as $position)
        {
            
             $quantity=$position->getQuantity(); 

                     
             $item_name=$position->name;
             $item_id=$position->id;
             $description=$position->particulars;
             $countable=$position->countable;

             $stype=Shops::findOne($shop)->shop_type;

            $item[]=array('quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$item_id,'flow'=>$flow,'description'=>$description,'countable'=>$countable,'shop'=>$shop,'shop_type'=>$stype);
        }

        //json_encode($response, JSON_UNESCAPED_SLASHES);
        if($item[0]['quantity']>0)
        {
             $sale->requested_item=json_encode($item);

            if(!$sale->save())
            {
                var_dump($sale->getErrors()); 
            }else{

                $cart->removeAll();
                ?>
<script type="text/javascript">
$("#3").hide();
alert('Ordering Transaction Initialized'); 
</script>
                <?php
                // $this->redirect(['requisitions/create']);
            }
            
        } 
    }


    // checkout 22

    public function actionCheckout22()
    {
        $flowid=Yii::$app->request->post('flowid'); 
        $instrument=Yii::$app->request->post('instrument'); 
        $status=Yii::$app->request->post('status'); 
        $seen=Yii::$app->request->post('seen'); 
        $cid=Yii::$app->request->post('cid'); 
        $origin=Yii::$app->request->post('origin'); 
        $department=Yii::$app->request->post('department'); 
        $title=Yii::$app->request->post('title'); 
        $task_type=Yii::$app->request->post('task_type');

        // $dtype=Yii::$app->request->post('dtype');
        $dsender=Yii::$app->request->post('dsender');
        $shop=Yii::$app->request->post('shop');
        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions();
         // var_dump($all_items);
         ob_start();

        $sale= new Requisitions();

        $sale->workflow_id=$flowid;
        $sale->cid=$cid;
        $sale->title=$title;
        $sale->originating_department=$department;
        $sale->raised_by=$origin;
        $sale->status=$status;
        $sale->instrument=$instrument;
        $sale->not_seen=$seen; 
        $sale->task_type=$task_type; 
        $sale->transaction_id=time().rand(1,9);        
        $sale->dsender_id=$dsender; 
       
        $item=array();

         foreach($positions as $position)
        {
            
             
             $quantity=$position->getQuantity(); 

             $description='';           
             $item_name=$position->item_name;
             $item_id=$position->item_id;

            $stype=Shops::findOne($shop)->shop_type;
            $item[]=array('quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$item_id,'shop'=>$shop,'shop_type'=>$stype);
        }
    
        //json_encode($response, JSON_UNESCAPED_SLASHES);
        if($item[0]['quantity']>0)
        {
             $sale->requested_item=json_encode($item);

            if(!$sale->save())
            {
                var_dump($sale->getErrors()); 
            }else{

                $cart->removeAll();
                ?>
<script type="text/javascript">
$("#3").hide();
alert('Product Transfer Transaction Initialized'); 
</script>
                <?php
                // $this->redirect(['requisitions/create']);
            }
            
        } 
    }


    public function actionCheckout3()
    {
        $flowid=Yii::$app->request->post('flowid'); 
        $instrument=Yii::$app->request->post('instrument'); 
        $status=Yii::$app->request->post('status'); 
        $seen=Yii::$app->request->post('seen'); 
        $cid=Yii::$app->request->post('cid'); 
        $origin=Yii::$app->request->post('origin'); 
        $department=Yii::$app->request->post('department'); 
        $title=Yii::$app->request->post('title'); 
        $task_type=Yii::$app->request->post('task_type');
        $vendor=Yii::$app->request->post('vendor');
        $legs=Yii::$app->request->post('legs');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions();
         // var_dump($all_items);

        $sale= new Requisitions();

        $sale->workflow_id=$flowid;
        $sale->cid=$cid;
        $sale->title=$title;
        $sale->originating_department=$department;
        $sale->raised_by=$origin;
        $sale->status=$status;
        $sale->instrument=$instrument;
        $sale->not_seen=$seen; 
        $sale->task_type=$task_type; 
        $sale->transaction_id=time().rand(1,9); 
        $sale->legs = $legs;
        // total, amount, details, quantity, item_name, 
        // $price=array();
        // $amount=array();
        // $total=array();
        // $quantity=array();
        // $description=array();
        $item=array();

        foreach($positions as $position)
        {
             $total=$position->getQuantity()*$position->price; 
             $amount=$position->price; 
             $quantity=$position->getQuantity(); 

           //  $description=$position->description;           
             $item_name=$position->name;
             $item_id=$position->id;
            $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$position->particulars,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$item_id,'vendor'=>$vendor,'countable'=>$position->countable, 'subject'=>$vendor,);
        }
        //json_encode($response, JSON_UNESCAPED_SLASHES);
        ob_start();
        if($item[0]['quantity']>0)
        {
             $sale->requested_item=json_encode($item);

            if(!$sale->save())
            {
                var_dump($sale->getErrors()); 
            }else{

                $cart->removeAll();
                ?>
<script type="text/javascript">
$("#1").hide();
alert('Resource Outflow Task Initialized'); 
</script>
                <?php
                // $this->redirect(['requisitions/create']);
            }
            
        } 
    }





    public function actionClearcart()
    {
        
        //$cart = \Yii::$app->cart->getPositions();
         $cart = new  \yz\shoppingcart\ShoppingCart();
         //\Yii::$app->cart->removeAll();
         $cart->removeAll();
         return $this->redirect(['/requisitions/land']);

    }

     public function actionClearcart2()
    {
        
        //$cart = \Yii::$app->cart->getPositions();
         $cart = new  \yz\shoppingcart\ShoppingCart();
         //\Yii::$app->cart->removeAll();
         $cart->removeAll();
         // return $this->redirect(['/sales/store']);

    }

    public function actionClearcart3()
    {
        
        //$cart = \Yii::$app->cart->getPositions();
         $cart = new  \yz\shoppingcart\ShoppingCart();
         //\Yii::$app->cart->removeAll();
         $cart->removeAll();
         // return $this->redirect(['/requisitions/outflow']);

    }

    public function actionNotecount()
    {
         $notifications_count=Notifications::find()->where(['=','notify',Yii::$app->user->identity->id])->andWhere(['cid'=>Yii::$app->user->identity->cid,'status'=>0])->count();
         \Yii::$app->response->data=$notifications_count;
    }

    public function actionRejcount()
    {
         $atcount2=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid,'rejected'=>1])->count();
         \Yii::$app->response->data=$atcount2;
    }

    public function actionAttencount()
    {
          $atcount=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','rejected',1])->andWhere(['=','concluded',0])->count();
         \Yii::$app->response->data=$atcount;
    }

    public function actionMessagecount()
    {
        $mecount=Messages::find()->where(['=','to_id',Yii::$app->user->identity->id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',0])->count();
       \Yii::$app->response->data=$mecount;
    }

    public function actionRevscount()
    {
        $dels1=Dels::find()->where(['=','done',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','ttype',1])->count();
       \Yii::$app->response->data=$dels1;
    }

    public function actionRevstcount()
    {
        $dels2=Dels::find()->where(['=','done',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','ttype',2])->count();
       \Yii::$app->response->data=$dels2;
    }

    public function actionDiskcount()
    {
        $disk=Discounts::find()->where(['=','status',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->count();
       \Yii::$app->response->data=$disk;
    }


     public function actionSumcount()
    {
        $notifications_count=Notifications::find()->where(['=','notify',Yii::$app->user->identity->id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',0])->count();
  
        $atcount2=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid,'rejected'=>1])->count();
   
        $atcount=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','rejected',1])->andWhere(['=','concluded',0])->count();
   
       $mecount=Messages::find()->where(['=','to_id',Yii::$app->user->identity->id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',0])->count();

       $disk=Discounts::find()->where(['=','status',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->count();

       $dels1=Dels::find()->where(['=','done',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','ttype',1])->count();

       $dels2=Dels::find()->where(['=','done',0])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','ttype',2])->count();

        $pendingcount=\frontend\modules\hr\models\PersonalDetails::find()->where(['=','approved',1])->andWhere(['=','cid',Yii::$app->user->identity->cid])->count();

        

        if(Yii::$app->user->identity->role=='Client Admin')
        {
            \Yii::$app->response->data=($notifications_count+$atcount2+$atcount+$mecount+$disk);
        }else if(Yii::$app->user->identity->role=='Shop Manager')
        {
            \Yii::$app->response->data=($notifications_count+$atcount2+$atcount+$mecount+$dels1);
        }else if(Yii::$app->user->identity->role=='Store Manager')
        {
            \Yii::$app->response->data=($notifications_count+$atcount2+$atcount+$mecount+$dels2);
        }else{
            \Yii::$app->response->data=($notifications_count+$atcount2+$atcount+$mecount+$pendingcount);
        }
    }

    public function actionUpdate_quantity()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $model=Inventory::findOne($id);
        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);

        if($model->countable==1){
        if($model->quantity>=$quantity){
        $cart->update($pot,$quantity);
    }
}else{  $cart->update($pot,$quantity);  }
    if($model->quantity<$quantity && $model->countable==1)
    {
        ?>
    <script type="text/javascript">
    alert("Insufficient Quantity for "+"<?= $model->name ?>"+". Only ("+<?= $model->quantity; ?>+") left");
    </script>
        <?php
    }
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
      $this->invoice($all_items,$client,$cart);
   

         
    }


    public function actionUpdate_quantity2()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');

        $cart = new  \yz\shoppingcart\ShoppingCart();       
$all = $cart->getPositions(); foreach($all as $a){ if(!empty($a->sender_id)){ $v=1; break; } }
        // start
    if($v==1){ 
         $model = Transfers::find()->where(['=','id',$id])->one(); $name=$model->item_name;
    }else{
        $model=Stores::findOne($id); $name=$model->name;
    }
        $pot=$cart->getPositionById($id);
        if($model->quantity>=$quantity){
        $cart->update($pot,$quantity);
    }

    if($model->quantity<$quantity)
    {
        ?>
    <script type="text/javascript">
    alert("Insufficient Quantity for "+"<?= $name ?>"+". Only ("+<?= $model->quantity; ?>+") left");
    </script>
        <?php
    }

        // end
     


         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>
<?php if(Yii::$app->user->identity->role!='Store Manager'){ ?>
       <h1 style="text-align:center;">Store Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">STORE VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>
        <?php
    }else{

        // if department is 6
        ?>
              <h1 style="text-align:center;">Store Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">STORE VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->item_name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>
        <?php
    }

}




public function actionUpdate_quantity30()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
$model=Stores::findOne($id);
        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
       
       // sart
  $pot=$cart->getPositionById($id);
        if($model->quantity>=$quantity){
        $cart->update($pot,$quantity);
    }

    if($model->quantity<$quantity)
    {
        ?>
    <script type="text/javascript">
    alert("Insufficient Quantity for "+"<?= $model->name ?>"+". Only ("+<?= $model->quantity; ?>+") left");
    </script>
        <?php
    }
        // stop
         $all_items = $cart->getPositions();
      

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>

       <h1 style="text-align:center;">Order Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">ORDER VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity30('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id30('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>
        <?php
    

}


    public function actionUpdate_quantity3()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>

        <h1 style="text-align:center;">Material Purchase List</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>


<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Description</td> <td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++;
$get=Stores::findOne($all->getid());
     ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textArea('description',$all->particulars,['class'=>'form-control camp','id'=>$all->getid().'description','style'=>'width:250px;','onkeyup'=>'update_description3('.$all->getid().')','readonly'=>true]) ?>
        </td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control camp','id'=>$all->getid().'quantity','style'=>'width:50px;','onkeyup'=>'update_quantity3('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= Html::textInput('price',$all->getPrice(),['class'=>'form-control camp','id'=>$all->getid().'price','style'=>'width:100px;','onkeyup'=>'update_price3('.$all->getid().',1)','autocomplete'=>'off']) ?><?= $get->cost_price!=null ? Html::button($get->cost_price,['class'=>'btn btn-primary','onclick'=>'update_price3('.$all->getid().',2)']) : '' ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id3('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="7">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }


    public function actionUpdate_price3()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $price=Yii::$app->request->post('price');
        $type=Yii::$app->request->post('type');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        // var_dump($pot); die;
        

        if($type==2){
            $my_item=Stores::findOne($id);
            $pot->price=$my_item->cost_price;
        }else{
            $pot->price=$price;
        }
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>

         <h1 style="text-align:center;">Material Purchase List</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>


<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Description</td> <td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){
    $get=Stores::findOne($all->getid());
     $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textArea('description',$all->particulars,['class'=>'form-control','id'=>$all->getid().'description','style'=>'width:250px;','onkeyup'=>'update_description3('.$all->getid().')','readonly'=>true]) ?>
        </td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:50px;','onkeyup'=>'update_quantity3('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= Html::textInput('price',$all->getPrice(),['class'=>'form-control','id'=>$all->getid().'price','style'=>'width:100px;','onkeyup'=>'update_price3('.$all->getid().',1)','autocomplete'=>'off']) ?><?= $get->cost_price!=null ? Html::button($get->cost_price,['class'=>'btn btn-primary','onclick'=>'update_price3('.$all->getid().',2)']) : '' ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id3('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="7">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }



    public function actionUpdate_description3()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $description=Yii::$app->request->post('description');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        $pot->description=$description;
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
    ?>

          <h1 style="text-align:center;">Material Purchase List</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>


<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Description</td> <td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textArea('description',$all->particulars,['class'=>'form-control camp','id'=>$all->getid().'description','style'=>'width:250px;','onkeyup'=>'update_description3('.$all->getid().')','autocomplete'=>'off','readonly'=>true]) ?>
        </td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control camp','id'=>$all->getid().'quantity','style'=>'width:50px;','onkeyup'=>'update_quantity3('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= Html::textInput('price',$all->getPrice(),['class'=>'form-control camp','id'=>$all->getid().'price','style'=>'width:100px;','onkeyup'=>'update_price3('.$all->getid().')','autocomplete'=>'off']) ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id3('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="7">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }


    public function actionRemove_byid()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        $this->invoice($all_items,$client,$cart);
        
    
    }



    public function actionRemove_byid2()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        
     ?>

               <h1 style="text-align:center;">Store Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">STORE VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity2('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id2('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

        <?php
    }


    public function actionRemove_byid30()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        
     ?>

               <h1 style="text-align:center;">Order Voucher</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">ORDER VOUCHER</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>

<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Description</td><td>Quantity</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->particulars) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity30('.$all->getid().')']) ?>
        </td>   
        
        <td><span onclick="remove_by_id30('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        
        <td></td>
    </tr>


    

    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
</div>

        <?php
    }


    public function actionRemove_byid3()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        
     ?>

       <h1 style="text-align:center;">Material Purchase List</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>


<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Description</td> <td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){
$get=Stores::findOne($all->getid());
     $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name ?></td>
        <td>
<?= Html::textArea('description',$all->particulars,['class'=>'form-control camp','id'=>$all->getid().'description','style'=>'width:250px;','onkeyup'=>'update_description3('.$all->getid().')','autocomplete'=>'off','readonly'=>true]) ?>
        </td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control camp','id'=>$all->getid().'quantity','style'=>'width:50px;','onkeyup'=>'update_quantity3('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= Html::textInput('price',$all->getPrice(),['class'=>'form-control camp','id'=>$all->getid().'price','style'=>'width:100px;','onkeyup'=>'update_price3('.$all->getid().',1)','autocomplete'=>'off']) ?><?= $get->cost_price!=null ? Html::button($get->cost_price,['class'=>'btn btn-primary','onclick'=>'update_price3('.$all->getid().',2)']) : '' ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id3('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
        <td></td>
    </tr>


    
<tr>
            <td colspan="7">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>

        <?php
    }
//
    public function actionSales_report()
    {
       
      if(Yii::$app->request->post())
      {
          
        $date1=Yii::$app->request->post('from');
        $date2=Yii::$app->request->post('to');
        $shop=Yii::$app->request->post('shop');
        $bank=Yii::$app->request->post('bank');
        $staff=Yii::$app->request->post('staff');
        $shift=Yii::$app->request->post('shift');

         $sales = (new \yii\db\Query())
           // ->select(['id'])
            // ->from('requisitions')
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            // ->andWhere('amount_paid!=:pa', [':pa' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            // ->andWhere('vendor!=:ba', [':ba' => 0]);
            // ->andWhere('vendor!=:ba1', [':ba1' => NULL]);
            // ->andWhere(['concluded'=>1]);
            if(!empty(Yii::$app->request->post('from')) && !empty(Yii::$app->request->post('to')))
            {
                $sales=$sales->andWhere(['between','SUBSTR(stamp,1,10)',$date1, $date2]);
            }

            if(!empty(Yii::$app->request->post('staff')))
            {
                $sales=$sales->andWhere(['staff'=>$staff]);
            }

            if(!empty(Yii::$app->request->post('shift')))
            {
                $sales=$sales->andWhere(['shift'=>$shift]);
            }

            if(!empty(Yii::$app->request->post('shop')))
            {
                $sales=$sales->andWhere(['shop_id'=>$shop]);
            }
            if(!empty(Yii::$app->request->post('bank')))
            {
                $sales=$sales->andWhere(['bank'=>$bank]);
            }

            if(Yii::$app->user->identity->role!='Client Admin' && Yii::$app->user->identity->role!='accounts' && Yii::$app->user->identity->role!='Shop Manager')
            {
                $sales=$sales->andWhere(['staff'=>Yii::$app->user->identity->id]);
            }
            $sales=$sales->andWhere('ptype=:tata', [':tata' =>1]) ;    

            $total=$sales->all();

            // $sales=$sales->groupBy('task_type');
            $sales=$sales->all();
            

            $total_income=0;
            $total_exp=0;
            $u=0;
            // foreach($total as $req)
            // {
            //     $sale=json_decode($req['requested_item'],true);
               
            //     $total_income+=$sale[$u]['total'];
            //     // var_dump($req);
            //     // $u++;
            // }
      }
      return $this->render('sales_report',['model'=>$sales,'from'=>$date1,'to'=>$date2,'bank'=>$bank,'shop'=>$shop,'staff'=>$staff]);
    }
       
    
    public function actionReadit()
    {
        $rid=Yii::$app->request->post('rid');
        $row=Yii::$app->request->post('row');
        $key=Yii::$app->request->post('dkey');
        $value=Yii::$app->request->post('value');

        $record=Requisitions::findOne($rid);
        $focus=json_decode($record->requested_item,true);
        $newvalue=$focus[$row][$dkey]=$value;
        json_encode($record->requested_item);
       // $record->requested_item=$done;
        if($record->save())
        {
            echo "success";
        }else{
            echo "failed";
        }
    }


    public function actionPendingcount()
    {
         $notifications_count=\frontend\modules\hr\models\PersonalDetails::find()->where(['=','approved',1])->andWhere(['cid'=>Yii::$app->user->identity->cid])->count();
         \Yii::$app->response->data=$notifications_count;
    }

    public function actionPendingcount2()
    {
         $notifications_count=\frontend\modules\hr\models\PersonalDetails::find()->where(['=','approved',4])->andWhere(['cid'=>Yii::$app->user->identity->cid])->count();
         \Yii::$app->response->data=$notifications_count;
    }

    // add vat to invoice

    public function actionAddvat()
    {
         $id=Yii::$app->request->post('item_id');
         $amount=Yii::$app->request->post('amount'); 
         $new_id = explode('-', $id);
         $id = $new_id[0];

         // access the cart from "cart" subcomponent
         $cart = new  \yz\shoppingcart\ShoppingCart();  

        

         if($new_id[1]=='vat'){
            // add vat
            $model = Inventory::find()->where(['name'=>'vat'])->one();
            $model->price = $amount;

            $pot=$cart->getPositionById($model->id);
            if($pot<1){
            $cart->put($model, 1); 
        }

           
         }


              

        
        if($cart->getcount()>0)
        { 
            // open (1) first check if the shopping cart has any items in it
            // this conditional is redundant and doing nowthing       
        }

    

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

       
      
       $this->invoice($all_items,$client,$cart);
    }


    // add consultancy

     public function actionAddcharge()
    {
         $id=Yii::$app->request->post('id');
         $name=Yii::$app->request->post('name'); 

         $customer_data = \frontend\models\Customers::findOne($id);
         

           // access the cart from "cart" subcomponent
        $cart = new  \yz\shoppingcart\ShoppingCart();  

             

            // admin charge
            $model = Inventory::find()->where(['name'=>'Admin & Consultancy Charge'])->one();
            $model->price = $customer_data->admin_charge;
            $cart->put($model, 1); 

            // add consultancy. removed this but may be added if required

            // $model = Inventory::find()->where(['name'=>'consultancy'])->one();
            // $model->price = $customer_data->consultancy;
            // $cart->put($model, 1); 
     


              

        
        if($cart->getcount()>0)
        { // open (1) first check if the shopping cart has any items in it
      
}

    

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);

       $this->invoice($all_items,$client,$cart);
       

        
    }


    function invoice($all_items,$client,$cart){
        
          ob_start();
        ?>



        <h1 style="text-align:center;">INVOICE</h1>

<div>

<table class="table " style="width:100%; margin:auto; border:1px solid #ccc; border-bottom:none;">
    <tr>
        <th colspan="3">
                <?= Html::img('@web/assets/logo/mlogo2.jpg', ['alt'=>'Morris Royal logo', 'style'=>'display:block; margin:auto; width:100px; height:auto']);?>
            </th>
    </tr>
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:10px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">INVOICE</td>
</tr>

<tr style="font-weight:bold;">
<td colspan="3"  style="text-align:center;">NO:<?php echo $record->transaction_id; ?></td>
</tr>



<tr style="font-weight:bold;">

<td colspan="2" style="">Department: <span style="font-weight:normal;"><?php echo ucfirst(Departments::findOne(Yii::$app->user->identity->department)->department_name);  ?></span></td>
<td colspan="1" style="">Date: <?php echo date('jS F Y');  ?></td>
</tr>
</table>

<table class="table table-bordered" style="width:100%; margin:auto;">
    <tr style="font-weight:bold;"><td>SN</td><td>Item Name</td><td>Quantity</td><td>Price</td><td>Total</td><td></td> </tr>
    <?php $c=0; foreach($all_items as $all){ $c++; ?>
    <tr >
        <td style="width:10%;"><?= $c ?></td>
        <td><?= $all->name.' - '.ucfirst($all->description) ?></td>
        <td>
<?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantity('.$all->getid().')','autocomplete'=>'off']) ?>
        </td>   
        <td style="width:20%;"><?= number_format($all->getPrice(),2) ?></td>
        <td><del>N</del> <?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
        <td><span onclick="remove_by_id('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
    </tr>
    <?php } ?>


<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <td style="font-weight:bold;">Total</td>
        <td><del>N</del> <?= number_format($cart->getCost(),2)  ?></td>
        <td></td>
    </tr>

<tr>
        <td><?php  ?></td>
        
        <td><?php  ?></td>
        <td><?php  ?></td>
        
        <!-- td style="font-weight:bold;">Amout Paid</td---->
        <td><?= Html::hiddenInput('amount_paid',0,['class'=>'form-control','id'=>'amount_paid','placeholder'=>'Enter amount paid']) ?></td>
        <td></td>
    </tr>
    
<tr>
            <td colspan="6">
<span style="font-weight:bold;">Amount in words:</span>  <?= ucfirst(Yii::$app->Formatter->asSpellout($cart->getCost())) ?> Naira Only.
</td>

    </tr>
    

    

    <?php if($show_what==2){ ?>
    <tr>

        <td colspan="3"><?= Html::a('Authorize',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>


    <?php if($show_what==3){ ?>
        <tr>

<td colspan="3"><?= Html::a('Approve',['/requisitions/approve','id'=>$record->id,'doc'=>$record->instrument],['class'=>'btn btn-primary']) ?></td>
        <td colspan="2"><?= Html::a('Reject',['/requisitions/decline','id'=>$record->id, 'doc'=>$record->instrument],['class'=>'btn btn-danger']) ?></td>
    </tr>
    <?php } ?>
    <tr>
<td></td>


    </tr>

</table>
<?php
    }


}
