<?php

namespace frontend\controllers;

use backend\models\Transfers;
use backend\models\User;
use backend\models\Workflow;
use frontend\models\Batches;
use frontend\models\Boq;
use frontend\models\David;
use frontend\models\Inventory;
use frontend\models\Productions;
use frontend\models\Requisitions;
use frontend\models\Shops;
use frontend\models\Stores;
use frontend\models\Vendors;
use Yii;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

class TransactionController extends \yii\web\Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['uledger', 'pledger', 'bledger', 'mmledger'],
                        'roles' => ['Client Admin'],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['expenditure_index', 'sales_index'],
                        'roles' => ['accounts'],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['sales_index'],
                        'roles' => ['Shop Manager'],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['docket', 'save_docket', 'utilize', 'dock_details', 'pledger', 'bledger'],
                        'roles' => ['Production Manager'],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['mledger', 'transfer_index',
                            'load_form', 'search', 'expenditure_index', 'sales_index', 'transfer_products', 'order_goods'],
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionExpenditure_index()
    {
        $model = new Requisitions();
        return $this->render('e_index', ['model' => $model]);
    }

    public function actionSales_index()
    {
        // if(Yii::$app->user->identity->department!=1)
        // {
        //   die('You are not authrized to do this');
        // }
        return $this->render('s_index');
    }

    public function actionTransfer_index()
    {
        return $this->render('t_index');
    }

    public function actionLoad_form()
    {
        $id = Yii::$app->request->post('id');
        $type = Yii::$app->request->post('type');
        $work = Workflow::find()->where(['task_id' => $id])->one();
        $status = explode(',', $work->int_workflow);
        $instrument = explode(',', $work->instrument);
        $model = new Requisitions();
        $form = ActiveForm::begin();

        $client = \backend\models\Clients::findOne(Yii::$app->user->identity->cid);

        ?>
<?php if ($type == 2) {?>
          <div class="well well-sm">
<?=Html::textInput('item', '', ['class' => 'form-control', 'onkeyup' => 'getItem()', 'id' => 'item', 'placeholder' => 'Type item name'])?>
    <div id="item_list">
    </div>
    </div>
    <div class="form-group">
<?=$form->field($model, 'customer')->hiddenInput(['maxlength' => true, 'value' => '', 'id' => 'customer'])->label(false)?>
</div>



<div class="well well-sm">
        <div>
<?=Html::textInput('custome', '', ['class' => 'form-control', 'onkeyup' => 'getItemC(' . $client->industry . ')', 'id' => 'custo', 'placeholder' => 'Enter Customer name', 'autocomplete' => 'off'])?>
    <div id="item_listC">
    </div>
    </div>




</div>

    <div class="well well-sm">
<?=Html::textArea('narration', '', ['class' => 'form-control', 'id' => 'narration', 'style' => 'width:650px;', 'placeholder' => 'Narration'])?>

</div>

<div class="well well-sm">
<?=Html::hiddenInput('vat', '', ['class' => 'form-control', 'id' => 'vat', 'style' => 'width:100px;', 'placeholder' => 'Vat', 'onchange' => 'addvat("' . $id . '-vat")'])?>

</div>

<div class="form-group">
<?=$form->field($model, 'title')->hiddenInput(['maxlength' => true, 'value' => 'Sales', 'id' => 'title'])->label(false)?>
</div>

<div>

    <?=Html::dropDownList('auto_legs', null, ArrayHelper::map(\frontend\models\AutoLegs::find()->where(['cid' => Yii::$app->user->identity->cid,'leg_type'=>1])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'auto_legs'])?>
</div>
 <?php }?>


<?php if ($type == 1) {?>
     <div id="1" style="display:block;">
      <div class="well well-sm">
 <?php echo Html::textInput('item', '', ['class' => 'form-control', 'onkeyup' => 'getItem3_new()', 'id' => 'item3', 'placeholder' => 'Start typing purchase item name']) ?>
</div>
<div id="item_list3"></div>
<div class="well well-sm">
  <?=Html::dropDownList('vendors', null, ArrayHelper::map(Vendors::find()->where(['cid' => Yii::$app->user->identity->cid])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'vendor'])?>
</div>

<div>

    <?=Html::dropDownList('auto_legs', null, ArrayHelper::map(\frontend\models\AutoLegs::find()->where(['cid' => Yii::$app->user->identity->cid,'leg_type'=>2])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'auto_legs'])?>
</div>
    <?=$form->field($model, 'title')->hiddenInput(['maxlength' => true, 'value' => 'Purchase', 'id' => 'title'])->label(false)?>

<?php }?>


<?php if ($type == 3) {?>
    <div>

<?=$form->field($model, 'title')->hiddenInput(['maxlength' => true, 'value' => 'Transfer', 'id' => 'title'])->label(false)?>
  <?php if (Yii::$app->user->identity->role == 'Store Manager') {echo $form->field($model, 'dsender_id')->dropDownList(
            ArrayHelper::map(User::find()->where(['cid' => Yii::$app->user->identity->cid])->andWhere(['!=', 'role', 'Store Manager'])->all(), 'id', 'label2'), ['prompt' => 'Who do you want to receive item(s) from?', 'id' => 'dsender'])->label(false);}?>
     <?php //echo $form->field($model, 'dtype')->dropDownList(
            // ['1'=>'Raw Material','2'=>'Finished Goods'],['prompt'=>'In what form are the requested items?','id'=>'dtype'])->label(false) ?>
   <div class="well well-sm">
    <?=Html::textInput('item', '', ['class' => 'form-control', 'onkeyup' => 'getItem2_new()', 'id' => 'item2', 'placeholder' => 'Type name of item for transfer'])?>
  </div>
    </div>
        <div id="item_list2">

    </div>


        <div class="well well-sm">
<?=Html::textArea('narration', '', ['class' => 'form-control', 'id' => 'narrationt', 'style' => 'width:650px;', 'placeholder' => 'Narration'])?>

</div>


<?php }?>


<?php if ($type == 5) {?>
    <div class="form-group">

<?=$form->field($model, 'title')->hiddenInput(['maxlength' => true, 'value' => 'Product Transfer', 'id' => 'title'])->label(false)?>
  <?php if (Yii::$app->user->identity->role == 'Store Manager') {echo $form->field($model, 'dsender_id')->dropDownList(
            ArrayHelper::map(User::find()->where(['cid' => Yii::$app->user->identity->cid])->andWhere(['!=', 'role', 'Store Manager'])->all(), 'id', 'label2'), ['prompt' => 'Who do you want to receive item(s) from?', 'id' => 'dsender'])->label(false);}?>
     <?php //echo $form->field($model, 'dtype')->dropDownList(
            // ['1'=>'Raw Material','2'=>'Finished Goods'],['prompt'=>'In what form are the requested items?','id'=>'dtype'])->label(false) ?>
    <?=Html::textInput('item', '', ['class' => 'form-control', 'onkeyup' => 'getItem3p_new()', 'id' => 'item2', 'placeholder' => 'Type name of item for transfer'])?>
    </div>
            <div class="well well-sm">
 <?=Html::dropDownList('shop', null, ArrayHelper::map(Shops::find()->where(['cid' => Yii::$app->user->identity->cid])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'shop2'])?>
    </div>
        <div id="item_list2">

    </div>


<?php }?>



<?php if ($type == 6) {?>
    <div class="form-group">

<?=$form->field($model, 'title')->hiddenInput(['maxlength' => true, 'value' => 'Ordering', 'id' => 'title'])->label(false)?>

     <?php //echo $form->field($model, 'dtype')->dropDownList(
            // ['1'=>'Raw Material','2'=>'Finished Goods'],['prompt'=>'In what form are the requested items?','id'=>'dtype'])->label(false) ?>
   <div class="well well-sm">
    <?=Html::textInput('item', '', ['class' => 'form-control', 'onkeyup' => 'getItem30_new()', 'id' => 'item2', 'placeholder' => 'Type name of item for transfer'])?>
  </div>
    </div>
        <div id="item_list2">

    </div>
    <div class="well well-sm">
 <?=Html::dropDownList('flow', null, ArrayHelper::map(David::find()->where(['id' => 1])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'flow'])?>
    </div>
       <div class="well well-sm">
 <?=Html::dropDownList('shop', null, ArrayHelper::map(Shops::find()->where(['cid' => Yii::$app->user->identity->cid])->all(), 'id', 'name'), ['class' => 'form-control', 'prompt' => '', 'id' => 'shop'])?>
    </div>


<?php }?>



      <?=$form->field($model, 'cid')->hiddenInput(['maxlength' => true, 'value' => $work->cid, 'id' => 'cid'])->label(false)?>

      <?=$form->field($model, 'originating_department')->hiddenInput(['maxlength' => true, 'value' => Yii::$app->user->identity->department, 'id' => 'department'])->label(false)?>
      <?=$form->field($model, 'raised_by')->hiddenInput(['maxlength' => true, 'value' => Yii::$app->user->identity->id, 'id' => 'origin'])->label(false)?>
      <?=$form->field($model, 'workflow_id')->hiddenInput(['maxlength' => true, 'value' => $work->id, 'id' => 'flowid'])->label(false)?>
      <?=$form->field($model, 'not_seen')->hiddenInput(['maxlength' => true, 'value' => $work->int_workflow, 'id' => 'seen'])->label(false)?>
      <?=$form->field($model, 'instrument')->hiddenInput(['maxlength' => true, 'value' => $instrument[0], 'id' => 'instrument'])->label(false)?>
      <?=$form->field($model, 'task_type')->hiddenInput(['maxlength' => true, 'value' => $type, 'id' => 'task_type'])->label(false)?>
      <?=$form->field($model, 'status')->hiddenInput(['maxlength' => true, 'value' => $status[0], 'id' => 'status'])->label(false)?>

<?php if ($type == 2) { // initially contained submit and cancel or clear cart button ?>

       <?php }?>



      <?php
}

    public function actionUtilize()
    {

        // $products=Boq::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
        return $this->render('utilize');
    }

    public function actionDocket()
    {
        // if(Yii::$app->request->post('Initialize'))
        // {
        //     var_dump($_POST); die;
        // }
        $products = Yii::$app->request->post('products');
        $batches = Yii::$app->request->post('batches');

        $dproducts = Boq::find()->where(['=', 'transaction_id', $products])->andWhere(['cid' => Yii::$app->user->identity->cid])->all();
        return $this->render('docket', ['products' => $dproducts, 'batches' => $batches, 'transaction_id' => $products]);
    }

    public function actionSave_docket()
    {
        //var_dump(Yii::$app->request->post());
        $batch = Yii::$app->request->post('batch'); //echo $batch; die('where is bach');
        $transaction_id = Yii::$app->request->post('transaction_id');

        $start = Boq::find()->where(['cid' => Yii::$app->user->identity->cid])->andWhere(['transaction_id' => $transaction_id])->all();

        $transaction_id = 'D' . time() . rand(1, 9);
        $bato = new Batches();
        $bato->estimate = $start[0]['estimate'] * $batch;
        $bato->product = $start[0]['product_name'];
        $bato->cid = Yii::$app->user->identity->cid;
        $bato->transaction_id = $transaction_id;

        $bab = $start[0]['estimate'] * $batch;

        $ten = array();

        $transaction = Yii::$app->db->beginTransaction();
        try {

            $check = Productions::find()->where( ['item_id' => $start[0]['product_name']])->andWhere(['cid' => Yii::$app->user->identity->cid])->one();
            if ($check == null) {
                $products = new Productions();
                $products->item_id = $sta['product_name'];
                $products->item_name = ucwords(Inventory::findOne($sta['product_name'])->name);
                $products->quantity = $sta['estimate'] * $batch;
                $products->cid = Yii::$app->user->identity->cid;
                $products->staff = Yii::$app->user->identity->id;
                $products->created_at = date('Y-m-d');
                $products->save();
            } else {
                $check->quantity += $bab;
                if (!$check->save()) {
                    // var_dump($check->getErrors()); die;
                    throw new \Exception('could not save to Productions');
                }
            }

            foreach ($start as $sta) {
                $mat = Stores::findOne($sta['material'])->name;
                $ten[] = array('material' => $mat, 'quantity' => $sta['quantity'] * $batch, 'item_id' => $sta['material']);

                $move = Transfers::find()->where(['item_id' => $sta['material']])->andWhere(['cid' => Yii::$app->user->identity->cid])->andWhere(['reciever_id' => Yii::$app->user->identity->id])->one();
                $move->quantity -= $sta['quantity'] * $batch;
                if (!$move->Save()) {
                    throw new \Exception('could not save to Transfers');
                }

            }

            $bato->items = json_encode($ten);
            $bato->created_at = date('Y-m-d');
            if (!$bato->save()) {
                // var_dump($bato->getErrors()); die;
                throw new \Exception('could not save to batches');
            }
            // else{

            //     Yii::$app->session->setFlash('success', "Materials succesfully deducted from personal ledger!");
            // }

            $transaction->commit();

        } catch (\Exception $e) {
            $transaction->rollBack();
            throw $e;die('failed');
        } catch (\Throwable $e) {
            $transaction->rollBack();
            throw $e;die('failed');
        }

        Yii::$app->session->setFlash('success', "Materials succesfully deducted from personal ledger!");
        return $this->redirect(['utilize']);
    }

//     public function actionSave_docket()
    //     {
    //         //var_dump(Yii::$app->request->post());
    //         $batch=Yii::$app->request->post('batch'); //echo $batch; die('where is bach');
    //         $transaction_id=Yii::$app->request->post('transaction_id');

//         $start=Boq::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$transaction_id])->all();

//         $transaction_id='D'.time().rand(1,9);
    //         $bato= new Batches();
    //         $bato->estimate=$start[0]['estimate']*$batch;
    //         $bato->product=$start[0]['product_name'];
    //         $bato->cid=Yii::$app->user->identity->cid;
    //         $bato->transaction_id=$transaction_id;

//         $bab=$start[0]['estimate']*$batch;

// $ten=array();
    //         foreach($start as $sta)
    //         {
    //             $mat=Stores::findOne($sta['material'])->name;
    //             $ten[]=array('material'=>$mat,'quantity'=>$sta['quantity']*$batch,'item_id'=>$sta['material']);

//             $move=Transfers::find()->where(['item_id'=>$sta['material']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['reciever_id'=>Yii::$app->user->identity->id])->one();
    //             $move->quantity-=$sta['quantity']*$batch;
    //             $move->Save();

//             $check=Productions::find()->where(['item_id'=>$sta['product_name']])->one();
    //             if($check==null)
    //             {
    //                 $products= new Productions();
    //                 $products->item_id=$sta['product_name'];
    //                 $products->item_name=ucwords(Inventory::findOne($sta['product_name'])->name);
    //                 $products->quantity=$sta['estimate']*$batch;
    //                 $products->cid=Yii::$app->user->identity->cid;
    //                 $products->staff=Yii::$app->user->identity->id;
    //                 $products->created_at=date('Y-m-d');
    //                 $products->save();
    //             }else{
    //               $check->quantity+=$bab;
    //               $check->save();
    //             }
    //         }
    //         $bato->items=json_encode($ten);
    //         $bato->created_at=date('Y-m-d');
    //         if(!$bato->save())
    //         {
    //             var_dump($bato->getErrors()); die;
    //         }else{

//             Yii::$app->session->setFlash('success', "Materials succesfully deducted from personal ledger!");
    //         }
    //         return $this->redirect(['utilize']);
    //     }

    public function actionSearch()
    {
        if (Yii::$app->request->post('Initialize')) {
            $results = (new \yii\db\Query())
            //  ->select(['id', 'email'])
            ->from('batches')
                ->where('id!=:sam', [':sam' => 0])
                ->andWhere('cid=:po', [':po' => Yii::$app->user->identity->cid])

                ->andWhere(['between', 'SUBSTR(created_at,1,10)', $_POST['from'], $_POST['to']])->all();
            // $string.=' Between '.date('jS F Y',strtotime($_POST['from'])).' and '.date('jS F Y',strtotime($_POST['to']));
        }
        return $this->render('search', ['results' => $results]);
    }

    public function actionDock_details($id)
    {
        $detail = Batches::find()->where(['id' => $id])->one();
        var_dump($detail);
        return $this->render('dock_details', ['detail' => $detail]);
    }

    public function actionMledger()
    {
        $rows = Transfers::find()->where(['=', 'reciever_id', Yii::$app->user->identity->id])->all();
        return $this->render('mledger', ['rows' => $rows]);
    }

    public function actionMmledger()
    {
        $user = User::find()->where(['role' => 'Production Manager'])->andWhere(['cid' => Yii::$app->user->identity->cid])->one();
        $rows = Transfers::find()->where(['=', 'reciever_id', $user->id])->all();
        return $this->render('mmledger', ['rows' => $rows]);
    }

    public function actionUledger()
    {

        if (Yii::$app->request->post()) {
            $id = Yii::$app->request->post('user');
            $item = Yii::$app->request->post('item');
            // $rows=Transfers::find()->where(['=','reciever_id',$id])->all();

            $rows = (new \yii\db\Query())
            // ->select(['id'])
            ->from('transfers')
                ->where('id!=:sam', [':sam' => 0])
                ->andWhere('cid=:po', [':po' => Yii::$app->user->identity->cid]);

            if (Yii::$app->request->post('user')) {
                $rows = $rows->andWhere('reciever_id=:h', [':h' => $id]);
            }

            if (Yii::$app->request->post('item')) {
                $rows = $rows->andWhere('item_id=:uj', [':uj' => $item]);
            }
            $rows = $rows->all();

            return $this->render('uledger', ['rows' => $rows]);
        }

        return $this->render('uledger');
    }

    public function actionPledger()
    {
        $products = Productions::find()->where(['cid' => Yii::$app->user->identity->cid])->all();
        return $this->render('pledger', ['products' => $products]);
    }

    public function actionBledger()
    {
        $batches = Batches::find()->where(['cid' => Yii::$app->user->identity->cid])->all();
        return $this->render('bledger', ['batches' => $batches]);
    }

    public function actionTransfer_products()
    {
        // if(Yii::$app->user->identity->department!=1)
        // {
        //   die('You are not authrized to do this');
        // }
        return $this->render('transfer_product');
    }

    public function actionOrder_goods()
    {
        return $this->render('order_goods');
    }

}
