<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Vendors;
use frontend\models\VendorsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * VendorsController implements the CRUD actions for Vendors model.
 */
class VendorsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
           'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','findModel','vledger'],
                    'roles' => ['@'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['create','delete','update'],
                    'roles' => ['Store Manager','Client Admin'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Vendors models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new VendorsSearch(['cid'=>Yii::$app->user->identity->cid]);
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Vendors model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Vendors model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Vendors();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Vendors model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Vendors model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Vendors model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Vendors the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Vendors::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


           public function actionVledger()
    {
  
        if(Yii::$app->request->post())
        {

           $vendor_name = Vendors::findOne(Yii::$app->request->post('vendor'))->name;

             $income = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('ptype=:kk',[':kk'=>2])
            ->andWhere('vendor=:j',[':j'=>Yii::$app->request->post('vendor')]);
         
            if(!empty(Yii::$app->request->post('from')) && !empty(Yii::$app->request->post('to')))
            {
                $income=$income->andWhere(['between','SUBSTR(created_at,1,10)',Yii::$app->request->post('from'), Yii::$app->request->post('to')]);
            }
                
           

            $income=$income->all();

            return $this->render('vledger',['income'=>$income,'vendor'=>$vendor_name]);


        }else{
          

        return $this->render('vledger');
    }
    }
}
