<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "charts".
 *
 * @property int $id
 * @property int $anumber
 * @property string $title
 * @property string $to_increase
 * @property string $description
 * @property int $cid
 * @property int $atype
 * @property int $account_group
 * @property int $pnl
 * @property string $created_at
 */
class Charts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'charts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['anumber', 'title', 'to_increase', 'description', 'cid', 'atype', 'account_group', 'pnl', 'created_at'], 'required'],
            [['anumber', 'cid', 'atype', 'account_group', 'pnl'], 'integer'],
            [['title', 'description'], 'string'],
             [['anumber'], 'unique'],
            [['created_at'], 'safe'],
            [['to_increase'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'anumber' => 'Anumber',
            'title' => 'Title',
            'to_increase' => 'To Increase',
            'description' => 'Description',
            'cid' => 'Cid',
            'atype' => 'Atype',
            'account_group' => 'Account Group',
            'pnl' => 'Pnl',
            'created_at' => 'Created At',
        ];
    }
}
