<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Charts;

/**
 * ChartsSearch represents the model behind the search form of `frontend\models\Charts`.
 */
class ChartsSearch extends Charts
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'anumber', 'cid', 'atype', 'account_group', 'pnl'], 'integer'],
            [['title', 'to_increase', 'description', 'created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Charts::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'anumber' => $this->anumber,
            'cid' => Yii::$app->user->identity->cid,
            'atype' => $this->atype,
            'account_group' => $this->account_group,
            'pnl' => $this->pnl,
            'created_at' => $this->created_at,
        ]);

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'to_increase', $this->to_increase])
            ->andFilterWhere(['like', 'description', $this->description]);

        return $dataProvider;
    }
}
