<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "customers".
 *
 * @property int $id
 * @property string $name
 * @property string $address
 * @property string $email
 * @property string $phone
 * @property int $cctype
 * @property int $cid
 * @property int $staff
 * @property string $created_at
 * @property string $updated_at
 * @property double $admin_charge
 * @property double $consultancy
 * @property double $vat
 */
class Customers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'customers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'cctype', 'cid'], 'required'],
            [['address'], 'string'],
            [['cctype', 'cid', 'staff'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['name'], 'string', 'max' => 225],
            [['email'], 'string', 'max' => 60],
            [['phone'], 'string', 'max' => 20],
            [['admin_charge', 'consultancy', 'vat'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'email' => 'Email',
            'phone' => 'Phone',
            'cctype' => 'Cctype',
            'cid' => 'Cid',
            'staff' => 'Staff',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'admin_charge' => 'Admin Charge'
        ];
    }
}
