<?php

namespace frontend\models;

use Yii;
use frontend\models\Taxes;
use backend\models\Clients;



/**
 * This is the model class for table "inventory".
 *
 * @property int $id
 * @property int $cid
 * @property string $barcode
 * @property string $name
 * @property string $description
 * @property double $quantity
 * @property double $supply_price
 * @property int $reorder
 * @property int $staff
 * @property double $price
 * @property string $created_at
 * @property string $updated_at
 * @property int $category
 * @property int $supplier
 * @property string $photo
 * @property int $countable
 * @property int $shop
 * @property int $item_id
 * @property int $transaction_id
 */
class Inventory extends \yii\db\ActiveRecord implements \yz\shoppingcart\CartPositionInterface
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'inventory';
    }

    public $admin_charge;
    public $consultancy;
    public $vat;

     
    use  \yz\shoppingcart\CartPositionTrait;
    public function getPrice()
    {
        $client=Clients::findOne(Yii::$app->user->identity->cid);
         if($client->industry==2)
            {
                 if(($this->price_category!=0 || !empty($this->price_category) || $this->price_category>0) && $this->supply_price>0)
                  {
                     // if price category is set then use supply_price to do calculation
                     $tax_total=0;
                     $taxes=Taxes::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

                     $cat=PriceCategory::findOne($this->price_category);
                     $mark=($this->supply_price*$cat->mark_up)/100;
                     $sale_price=$this->supply_price+$mark;

                     foreach($taxes as $tax)
                     {
                      $tax_total+=$tax->rate;
                     }

                     $ftax=($sale_price*$tax_total)/100;
                     return $sale_price+$ftax;
                   }else{
                      // if sales category is not set then use set price 
                     $tax_total=0;
                     $taxes=Taxes::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

                     // $cat=PriceCategory::findOne($this->price_category);
                     // $mark=($this->price*$cat->mark_up)/100;
                     $sale_price=$this->price;

                     foreach($taxes as $tax)
                     {
                      $tax_total+=$tax->rate;
                     }

                     $ftax=($sale_price*$tax_total)/100;
                     return $sale_price+$ftax;
                    // return $this->price;
                   }
        }else{
                return $this->price;
        }
    }

    public function getId()
    {
        return $this->id;
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'staff', 'price','countable'], 'required'],
            // [['cid', 'reorder', 'staff', 'category', 'supplier','countable','shop','item_id'], 'integer'],
            [['cid', 'reorder', 'staff', 'category', 'supplier', 'countable', 'item_id', 'shop', 'shop_type', 'price_category', 'shelf'], 'integer'],
            [['description'], 'string'],
            [['quantity', 'supply_price', 'price'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['barcode'], 'string', 'max' => 200],
            [['name'], 'string', 'max' => 250],
            [['transaction_id'], 'string', 'max'=>'265'],
            // [['photo'], 'string', 'max' => 100],
            [['barcode'], 'unique'],
            [['photo'], 'file'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Client Id',
            'barcode' => 'Barcode',
            'name' => 'Name',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'supply_price' => 'Supply Price',
            'reorder' => 'Reorder',
            'staff' => 'Staff',
            'price' => 'Price',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'category' => 'Category',
            'supplier' => 'Supplier',
            'photo' => 'Photo',
            'countable' => 'Deductable / Non-deductable'
        ];
    }

    public function getLabel()
    {
        return $this->name.' - '.$this->quantity;
    }

    public function getLabel2()
    {
        return $this->name.' - '.ucfirst($this->description);
    }

    // public function getReorders()
    // {
    //     $list=Inventory::find()->where(['<',$this->quantity,$this->reorder])->all();
    //     return $list;
    // }
}
