<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "ledger2".
 *
 * @property int $id
 * @property int $cid
 * @property int $department
 * @property string $description
 * @property double $credit
 * @property double $amount_paid
 * @property double $debit
 * @property string $transaction_id
 * @property string $vendor
 * @property int $open
 * @property int $ptype
 * @property int $bank
 * @property int $aorb
 * @property string $tlink
 * @property int $shop_id
 * @property string $details
 * @property int $staff
 * @property int $chart_account
 * @property int $chart_account2
 * @property int $account_group
 * @property int $account_group2
 * @property int $entry_group
 * @property int $entry_group2
 * @property int $entry_type
 * @property int $entry_type2
 * @property string $dsource
 * @property string $created_at
 * @property string $updated_at
 * @property int $payment_method
 * @property string $table_no
 * @property int $status
 * @property int $shift
 * @property string $stamp
 */
class Ledger2 extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ledger2';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'department', 'description', 'credit', 'debit', 'transaction_id', 'vendor', 'staff'], 'required'],
            [['cid', 'department', 'open', 'ptype', 'bank', 'aorb', 'shop_id', 'staff', 'chart_account', 'chart_account2', 'account_group', 'account_group2', 'entry_group', 'entry_group2', 'entry_type', 'entry_type2', 'payment_method', 'status', 'shift'], 'integer'],
            [['description', 'details'], 'string'],
            [['credit', 'amount_paid', 'debit'], 'number'],
            [['created_at', 'updated_at', 'stamp'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['vendor', 'tlink'], 'string', 'max' => 225],
            [['dsource'], 'string', 'max' => 5],
            [['table_no'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'department' => 'Department',
            'description' => 'Description',
            'credit' => 'Credit',
            'amount_paid' => 'Amount Paid',
            'debit' => 'Debit',
            'transaction_id' => 'Transaction ID',
            'vendor' => 'Vendor',
            'open' => 'Open',
            'ptype' => 'Ptype',
            'bank' => 'Bank',
            'aorb' => 'Aorb',
            'tlink' => 'Tlink',
            'shop_id' => 'Shop ID',
            'details' => 'Details',
            'staff' => 'Staff',
            'chart_account' => 'Chart Account',
            'chart_account2' => 'Chart Account2',
            'account_group' => 'Account Group',
            'account_group2' => 'Account Group2',
            'entry_group' => 'Entry Group',
            'entry_group2' => 'Entry Group2',
            'entry_type' => 'Entry Type',
            'entry_type2' => 'Entry Type2',
            'dsource' => 'Dsource',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'payment_method' => 'Payment Method',
            'table_no' => 'Table No',
            'status' => 'Status',
            'shift' => 'Shift',
            'stamp' => 'Stamp',
        ];
    }
}
