<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "ledgergo".
 *
 * @property int $id
 * @property int $cid
 * @property int $department
 * @property string $description
 * @property double $credit
 * @property double $amount_paid
 * @property double $debit
 * @property string $transaction_id
 * @property string $vendor
 * @property int $open
 * @property int $ptype
 * @property int $bank
 * @property int $aorb a for advance and b for balance. to specify if this is balance or advance payment
 * @property string $tlink original transaction link
 * @property string $created_at
 * @property string $updated_at
 */
class Ledgergo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ledgergo';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'department', 'description', 'credit', 'debit', 'transaction_id', 'vendor'], 'required'],
            [['cid', 'department', 'open', 'ptype', 'bank', 'aorb'], 'integer'],
            [['description'], 'string'],
            [['credit', 'amount_paid', 'debit'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['vendor', 'tlink'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'department' => 'Department',
            'description' => 'Description',
            'credit' => 'Credit',
            'amount_paid' => 'Amount Paid',
            'debit' => 'Debit',
            'transaction_id' => 'Transaction ID',
            'vendor' => 'Vendor',
            'open' => 'Open',
            'ptype' => 'Ptype',
            'bank' => 'Bank',
            'aorb' => 'Aorb',
            'tlink' => 'Tlink',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
