<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Requisitions;

/**
 * RequisitionsSearch represents the model behind the search form of `frontend\models\Requisitions`.
 */
class RequisitionsSearch extends Requisitions
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'originating_department', 'raised_by', 'workflow_id', 'status'], 'integer'],
            [['requested_item', 'details', 'created_at', 'updated_at'], 'safe'],
          
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Requisitions::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => $this->cid,
            'originating_department' => $this->originating_department,
            'raised_by' => $this->raised_by,
      
            'workflow_id' => $this->workflow_id,
            
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'requested_item', $this->requested_item]);
            
            

        return $dataProvider;
    }
}
