<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Reservations;

/**
 * ReservationsSearch represents the model behind the search form of `frontend\models\Reservations`.
 */
class ReservationsSearch extends Reservations
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'number_of_rooms', 'staff', 'payment'], 'integer'],
            [['contact_person', 'phone', 'reservation_date', 'created_at'], 'safe'],
            [['amount_paid', 'discount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Reservations::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'number_of_rooms' => $this->number_of_rooms,
            'reservation_date' => $this->reservation_date,
            'amount_paid' => $this->amount_paid,
            'discount' => $this->discount,
            'created_at' => $this->created_at,
            'staff' => $this->staff,
            'payment' => $this->payment,
        ]);

        $query->andFilterWhere(['like', 'contact_person', $this->contact_person])
            ->andFilterWhere(['like', 'phone', $this->phone]);

        return $dataProvider;
    }
}
