<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "allowances".
 *
 * @property int $id
 * @property int $cid
 * @property string $allowance_name
 * @property int $allowance_group
 * @property double $percentage
 */
class Allowances extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'allowances';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'allowance_name','allowance_group','percentage'], 'required'],
            [['cid'], 'integer'],
            [['allowance_name'], 'string', 'max' => 255],
            [['percentage'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'allowance_name' => 'Allowance Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AllowancesQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AllowancesQuery(get_called_class());
    }
}
