<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "deductions".
 *
 * @property int $id
 * @property int $cid
 * @property string $name
 */
class Deductions extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'deductions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'name'], 'required'],
            [['cid'], 'integer'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'name' => 'Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return DeductionsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new DeductionsQuery(get_called_class());
    }
}
