<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "educational_details".
 *
 * @property int $id
 * @property int $cid
 * @property int $staff_id
 * @property int $institution_type
 * @property string $start_date
 * @property string $end_date
 * @property string $qualification
 * @property string $institution_name
 */
class EducationalDetails extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'educational_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff_id', 'institution_type', 'start_date', 'end_date', 'qualification', 'institution_name'], 'required'],
            [['cid', 'staff_id', 'institution_type'], 'integer'],
            [['qualification', 'institution_name'], 'string'],
            [['start_date', 'end_date'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'staff_id' => 'Staff ID',
            'institution_type' => 'Institution Type',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'qualification' => 'Qualification',
            'institution_name' => 'Institution Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return EducationalDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EducationalDetailsQuery(get_called_class());
    }
}
