<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "employment_details".
 *
 * @property int $id
 * @property string $employment_date
 * @property int $designation
 * @property int $section this is the departments of each staff
 * @property int $employment_type
 * @property int $location this is what morris royal calls units
 * @property int $cadre
 * @property string $supervisor_name
 * @property int $staff_id
 * @property int $cid
 * @property int $shift_hours
 * @property double $gross_pay
 * @property int $client these are clients for guards but morris oryal calls section
 */
class EmploymentDetails extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */    
    public static function tableName()
    {
        return 'employment_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['employment_date', 'designation', 'section', 'employment_type', 'location', 'cadre', 'staff_id', 'cid', 'client','shift_hours'], 'required'],
            [['designation', 'section', 'employment_type', 'location', 'cadre', 'staff_id', 'cid', 'client','shift_hours'], 'integer'],
            [['employment_date'], 'string', 'max' => 17],
            [['supervisor_name'], 'string', 'max' => 255],
            [['gross_pay'], 'number'],
            // [['staff_id'], 'unique','on'=>'create'],
              [['staff_id'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'employment_date' => 'Employment Date',
            'designation' => 'Designation',
            'section' => 'Department',
            'employment_type' => 'Employment Type',
            'location' => 'Unit',
            'cadre' => 'Cadre',
            'supervisor_name' => 'Supervisor Name',
            'staff_id' => 'Staff ID',
            'cid' => 'Cid',
            'client' => 'Section',
            'shift_hours' => 'Hours in shift',
            'gross_pay' => 'Gross Pay'
        ];
    }

    /**
     * {@inheritdoc}
     * @return EmploymentDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EmploymentDetailsQuery(get_called_class());
    }

    public function getSdetails()
    {
        return $this->belongsTo(Section::class,['id'=>'section']);
    }

    public function getCdetails()
    {
        return $this->belongsTo(ClientAccount::class,['client'=>'id']);
    }
}
