<?php

namespace frontend\modules\hr\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\modules\hr\models\PastEmploymentDetails;

/**
 * PastEmploymentDetailsSearch represents the model behind the search form of `frontend\modules\hr\models\PastEmploymentDetails`.
 */
class PastEmploymentDetailsSearch extends PastEmploymentDetails
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'employment_type', 'staff_id'], 'integer'],
            [['name_of_employer', 'address', 'phone', 'employment_period', 'last_position_held'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PastEmploymentDetails::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => $this->cid,
            'employment_type' => $this->employment_type,
            'staff_id' => $params['sid'],
        ]);

        $query->andFilterWhere(['like', 'name_of_employer', $this->name_of_employer])
            ->andFilterWhere(['like', 'address', $this->address])
            ->andFilterWhere(['like', 'phone', $this->phone])
            ->andFilterWhere(['like', 'employment_period', $this->employment_period])
            ->andFilterWhere(['like', 'last_position_held', $this->last_position_held]);

        return $dataProvider;
    }
}
