<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "temp_deductions".
 *
 * @property int $id
 * @property int $cid
 * @property int $staff_id
 * @property double $surcharge
 * @property double $advance
 * @property string $month
 * @property int $client
 */
class TempDeductions extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'temp_deductions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff_id', 'surcharge', 'advance', 'month', 'client'], 'required'],
            [['cid', 'staff_id', 'client'], 'integer'],
            [['surcharge', 'advance'], 'number'],
            [['month'], 'string', 'max' => 12],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'staff_id' => 'Staff ID',
            'surcharge' => 'Surcharge',
            'advance' => 'Advance',
            'month' => 'Month',
            'client' => 'Client',
        ];
    }

    /**
     * {@inheritdoc}
     * @return TempDeductionsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new TempDeductionsQuery(get_called_class());
    }
}
