<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel frontend\modules\hr\models\ClientAccountSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Client Accounts';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="client-account-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Client Account', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'cid',
            'client_name',
            'address:ntext',
            'company_number',
            //'email:email',
            //'contact_person',
            //'created_at',
            //'contact_number',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
