<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\modules\hr\models\ClientAccount;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\ClientUnits */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="client-units-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    
    <?php echo $form->field($model, 'client_account')->dropDownList(
    ArrayHelper::map(ClientAccount::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','client_name'),['prompt'=>'']) ?>

    <?= $form->field($model, 'unit_name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'unit_address')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'created_at')->hiddenInput(['value'=>date('Y-m-d')])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
