<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\PersonalDetails */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Personal Details', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="personal-details-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
        <?= Html::a('Back to Staff Details', ['personaldetails/index'], ['class' => 'btn btn-primary']) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
        ['label'=>'Past Employment Details', 'format'=>'raw', 'value'=>Html::a('Past Employment',['/hr/pastemploymentdetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             ['label'=>'Educational Details', 'format'=>'raw', 'value'=>Html::a('Educational Details',['/hr/educationaldetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             ['label'=>'Deployment Details', 'format'=>'raw', 'value'=>Html::a('Deployment Details',['/hr/employmentdetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             ['label'=>'Guarantor Details', 'format'=>'raw', 'value'=>Html::a('Guarantor',['/hr/guarantor/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             // ['label'=>'Emolument Details', 'format'=>'raw', 'value'=>Html::a('Emolument Details',['/hr/paymentdetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             ['label'=>'Administrative Details', 'format'=>'raw', 'value'=>Html::a('Admin Details',['/hr/admindetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             // ['label'=>'Payment  Details', 'format'=>'raw', 'value'=>Html::a('Payment Details',['/hr/paymentdetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
             ['label'=>'Staff Details', 'format'=>'raw', 'value'=>Html::a('Complete Details',['/hr/personaldetails/summary','sid'=>$model->id],['class'=>'btn btn-primary'])],

            // 'id',
            // 'cid',
             'surname',
            'firstname',
            'other_names',               
            ['label'=>'Date of birth', 'format'=>'raw', 'value'=>date('jS F Y',strtotime($model->dob))],        
            ['label'=>'Nationality', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Nationality::findOne($model->nationality)->nation],
            'nin',
            'nir',
            'tin',            
            ['label'=>'Marital Status', 'format'=>'raw', 'value'=>$model->marital_status==2 ? 'Married' : ($model->marital_status == 1 ? 'Single' : 'Not set')],
            'name_of_spouse',
            'residential_address',
            'permanent_home_address',
            'telephone',
            'email:email',
            ['label'=>'Gender', 'format'=>'raw', 'value'=>$model->gender==1 ? 'Male' : ($model->gender == 2 ? 'Female' : 'Not set')],
            'address_of_spouse:ntext',            
            ['label'=>'Account Type', 'format'=>'raw', 'value'=>$model->account_type==1 ? 'Savings' : ($model->account_type == 2 ? 'Current' : 'Not set')],

            'account_number',
            'spouse_telephone',
            'name_of_banker',
            'name_of_PFA',
            'name_of_PFC',
            'RSA_number',
             

        ],
    ]) ?>

</div>
