<?php

namespace frontend\modules\retails\controllers;

use Yii;
use namespace frontend\modules\retails\models\Accounts;
use namespace frontend\modules\retails\models\Purse;
use namespace frontend\modules\retails\models\AccountsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use namespace frontend\modules\retails\models\Taken;
use namespace frontend\modules\retails\models\Ledger;

/**
 * AccountsController implements the CRUD actions for Accounts model.
 */
class AccountsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Accounts models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new Accounts();
        if(Yii::$app->user->identity->role!='accounts')
        {
            die('not authorized');
        }

        $this->layout='column1';
        $searchModel = new AccountsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Accounts model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Accounts model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Accounts();
        if(Yii::$app->user->identity->role!='accounts')
        {
            die('not authorized');
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Accounts model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Accounts model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die;
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Accounts model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Accounts the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Accounts::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionFund()
    {
        // $accounts=Accounts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
         if(Yii::$app->user->identity->role!='accounts')
        {
            die('You are not authorized');
        }
        $model=new Purse;
        return $this->render('fund',['model'=>$model]);
    }


    public function actionGenerate($id)
    {
        // $accounts=Taken::find()->where(['bill_to'=>2,'cid'=>Yii::$app->user->identity->cid])->all();
         $query="select sum(credit) as credit, sum(amount_paid) as amount_paid, staff, details, created_at, transaction_id, vendor from ledger where ptype=1 and cid='".Yii::$app->user->identity->cid."' and vendor='".$id."'";
        

        $debtors=Ledger::findBySql($query)->one();
        // var_dump($debtors); die;
       
        return $this->render('generate',['bill'=>$debtors]);
    }


    public function actionHistory($id)
    {
        $name=\namespace frontend\modules\retails\models\Customers::findOne($id)->name;
        $list=\namespace frontend\modules\retails\models\History::find()->where(['account'=>$id,'cid'=>Yii::$app->user->identity->cid])->all();
        $purse=\namespace frontend\modules\retails\models\Purse::find()->where(['account'=>$id,'cid'=>Yii::$app->user->identity->cid])->one();
        return $this->render('history',['name'=>$name,'list'=>$list,'purse'=>$purse->amount]);
    }

/*

    public function actionGenerate()
    {
        $accounts=Taken::find()->where(['bill_to'=>2,'cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','company','NULL'])->all();
        // $bills=Ledger::find()->where
        // var_dump($accounts); die;
        $list=array();
        foreach($accounts as $acc)
        {
            array_push($list, $acc->transaction_id);
        }
       
        // $list=array_unique($list);
        $string = implode('","',$list);

         // var_dump($list);
        // $bills_q="SELECT * FROM ledger WHERE transaction_id IN ('".$string."')";
        $bills_q = 'SELECT vendor FROM ledger WHERE transaction_id IN ("'.$string.'")';
        $bills = Yii::$app->db->createCommand($bills_q)->queryAll(); 
        // var_dump($bills);
        // die;
        return $this->render('generate',['bills'=>$bills]);
    }
    */

 
}
