<?php

namespace frontend\modules\retails\controllers;

use Yii;
use frontend\modules\retails\models\Customers;
use frontend\modules\retails\models\CustomersSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\modules\retails\models\Taken;
use frontend\modules\retails\models\Rooms;
use frontend\modules\retails\models\Inventory;
use frontend\modules\retails\models\Ledger;
use frontend\modules\retails\models\Config;
use backend\models\Shops;
use frontend\modules\retails\models\Banks;
use frontend\modules\retails\models\Rooms2;
use frontend\modules\retails\models\Shifts;

require Yii::getAlias('@vendor') . '/mike42/escpos-php/autoload.php';
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
        use Mike42\Escpos\Printer;

date_default_timezone_set('Africa/Lagos');
/**
 * CustomersController implements the CRUD actions for Customers model.
 */
class CustomersController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Customers models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CustomersSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionIndexco()
    {
        
       
        $searchModel = new CustomersSearch(['cctype'=>2]);
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'cctype'=>2
        ]);
    }

    

    /**
     * Displays a single Customers model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $model=$this->findModel($id);
        // $model->name=stripslashes($model->name);
        return $this->render('view', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new Customers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Customers();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
           // $model->name=htmlspecialchars_decode($model->name, ENT_QUOTES);
            $check=Customers::find()->where(['name'=>$model->name,'phone'=>$model->phone,'cid'=>Yii::$app->user->identity->cid])->one();
            if($check==null){
            $model->save();

            return $this->redirect(['view', 'id' => $model->id]);
        }else{
            die('Customer already exists');
        }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Customers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $search=['\'','"','#'];

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            // $model->name=htmlspecialchars_decode($model->name, ENT_QUOTES);
            // $model->name=str_replace($search, '', $model->name);
            // $model->name=Yii::$app->db->quoteValue($model->name);
            // $model->name=mysqli_escape_string($model->name);
            // $model->name=\CDbConnection::quoteValue($model->name);
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Customers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Customers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Customers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Customers::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

     public function actionSaveit()
    {
        if(Yii::$app->request->post() && Yii::$app->user->identity->department==1 && Yii::$app->user->identity->place==2)
            {
                
                $s=0;

                $name=Yii::$app->request->post('name');
                $email=Yii::$app->request->post('email');
                $phone=Yii::$app->request->post('phone');
                $address=Yii::$app->request->post('address');
                $cctype=Yii::$app->request->post('cctype');

                $check=Customers::find()->where(['phone'=>$phone,'cid'=>Yii::$app->user->identity->cid])->one();
                if($check==null)
                {

                $customer=new Customers();

                $customer->name=$name;
                $customer->email=$email;
                $customer->address=$address;
                $customer->phone=$phone;
                $customer->cctype=$cctype;
                $customer->cid=Yii::$app->user->identity->cid;
                $customer->created_at=date('Y-m-d H:i:s');
                if($customer->save())
                {
                    $s=1;
                }
            }else{
                $s=2;
            }

                \Yii::$app->response->data=$s;
           }
    }

    public function actionCledger()
    {
  
        if(Yii::$app->request->post())
        {
            // $_POST['sent']

            $customer_name = Customers::findOne(Yii::$app->request->post('vendor'))->name;
      

             $income = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('ptype=:kk',[':kk'=>1])
            ->andWhere('vendor=:j',[':j'=>Yii::$app->request->post('vendor')]);

          

         
            if(!empty(Yii::$app->request->post('from')) && !empty(Yii::$app->request->post('to')))
            {
                $income=$income->andWhere(['between','SUBSTR(created_at,1,10)',Yii::$app->request->post('from'), Yii::$app->request->post('to')]);
            }
                
           

            $income=$income->all();

            return $this->render('cledger',['income'=>$income,'vendor'=>$customer_name]);


        }else{
          

        return $this->render('cledger');
    }
    }


    public function actionFillup()
    {
        ob_start();
        $name=Yii::$app->request->post('name');
        if(!empty($name)){
        $person=Customers::find()->where(['like','name',$name])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();
        foreach($person as $per)
        {
            ?>
<span style="background-color:#369; color:#fff; padding:5px; display:block; border-bottom:1px solid #fff; cursor:pointer;" onclick="add_name2('<?= $per->id ?>')"><?= ucwords($per->name) ?></span> 
            <?php
        }

    }
}

    public function actionFillup2()
    {
        ob_start();
        $name=Yii::$app->request->post('name');
        $target=Customers::find()->where(['id'=>$name])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        echo json_encode(array('namea'=>$name,'addresso'=>$target['address'],'email'=>$target['email'],'phone'=>$target['phone'],'dname'=>ucwords($target['name'])));
    }

    public function actionFillup3()
    {
        ob_start();
        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

        $values=array();    
         
        parse_str(Yii::$app->request->post('goal'),$values);

        // var_dump($values);

        $rcode=Yii::$app->request->post('rcode');
        $account1=Yii::$app->request->post('account1');

        $guest_id=(int)$values['guest_id'];
        $address=$values['addresso'];
        $phone=$values['phoneo'];
        $email=$values['emailo'];
        $nok=$values['nok'];
        $room_no=$rcode;
        $deposit=(double)$values['deposito'];
        $payment=$values['payment'];
        $idtype=$values['idtype'];
        $id_no=$values['id_no'];
        $room_type=$values['room_type'];
        $departure=$values['departureo'];
        $created_at=date("Y-m-d H:i:s");

        $bill_to=$values['bill_to'];
        $company=$values['company'];
       

        $transaction_id=time().rand(1,9);


        // $now=time();
        // $mydate=strtotime($departure);
        // $diff=$mydate-$now;
        // $michael=round($diff/(60*60*24));

        $date1=date_create(date('Y-m-d'));
        $date2=date_create(substr($departure,0,10));
        $diff=date_diff($date2,$date1);
        $michael=(int)$diff->format("%a");

                           
                                $michael+=1;
                            

        $price=Inventory::find()->where(['id'=>$room_type])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
       

        $total=$michael*$price->price;

        $details[]=array('shop_id'=>Yii::$app->user->identity->shop_id,'price'=>$price->price,'quantity'=>$michael,'item_name'=>$price->name,'hotel'=>1);

        
        $transaction = Yii::$app->db->beginTransaction();
        try {

        $take=new Taken();
        
        $take->address=$address;
        $take->phone=$phone;
        $take->email=$email;
        $take->room_no=$room_no;
        $take->room_type=$room_type;
        $take->deposit=$deposit;
        $take->payment_method=$payment;
        $take->guest_id=$guest_id;
        $take->departure=$departure;
        $take->nok=$nok;
        $take->transaction_id=$transaction_id;
        $take->cid=Yii::$app->user->identity->cid;
        $take->id_type=$idtype;
        $take->id_no=$id_no;
        $take->created_at=$created_at;  
        $take->bill_to=$bill_to;
        $take->company=$account1;
       
           

        if(!$take->save())
        {
           // var_dump($take->getErrors());
            throw new \Exception( 'Cant save to taken' );
        }

        $room=Rooms::find()->where(['room_type'=>$room_type])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        $use=$room->rooms;
        $hen=json_decode($use,true);
        $key=array_search($rcode, $hen);
        unset($hen[$key]);
        // var_dump($hen);
        
        $nhen=array_values($hen);
        $nhen=json_encode($nhen);
        $room->rooms=$nhen;
        if(!$room->save()){
           // var_dump($room->getErrors());
            throw new \Exception( 'Cant save to taken' );
        }

                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=$transaction_id;
                $ledger->vendor=(string)$guest_id;

                if(!empty($account1)){ 
                $ledger->vendor=(string)$account1; 
                }  
                $ledger->amount_paid=$deposit;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->bank=$config->bank;
                if(!$ledger->save())
                {
                    
                   throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                }

        $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }
            ?>
<div style="display:block; text-align:center; font-size:20px; margin:auto; margin-top:30px;">Room <?= $rcode ?> has been booked Successfully!</div>
            <?php

    }

    public function actionGuests()
    {
        $shop=Shops::findOne(Yii::$app->user->identity->shop_id);
        if($shop->shop_type!=3 && Yii::$app->user->identity->department!=1)
        {
            die('You are not authorized');
        }
        $guests=Taken::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['status'=>1])->all();
        return $this->render('guests',['guests'=>$guests]);
    }


    public function actionHouseg(){

        if(Yii::$app->request->post())
        {
            $from=Yii::$app->request->post('from');
            $query="select sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=1 and shop_id='".Yii::$app->user->identity->shop_id."' and substr(created_at,1,10)='".$from."' and amount_paid>0 group by vendor";       
        }else{
        // $houseg=Ledger::find()->where(['substr(created_at,1,10)'=>date('Y-m-d'),'shop_id'=>Yii::$app->user->identity->shop_id])->andWhere(['>','amount_paid',0])->sum('amount_paid')->groupBy(['vendor'])->all();
        $query="select sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=1 and shop_id='".Yii::$app->user->identity->shop_id."' and substr(created_at,1,10)='".date('Y-m-d')."' and amount_paid>0 group by vendor";       
        }

        $houseg=Ledger::findBySql($query)->all();
        return $this->render('houseg',['houseg'=>$houseg]);
    }

    public function actionCheckout()
    {
        $shift=Shifts::find()->where(['shift_name'=>Yii::$app->user->identity->id,'status'=>1])->one();

        $id=Yii::$app->request->post('id');
        $room=Yii::$app->request->post('room_no'); 
        $rtype=Yii::$app->request->post('room_type');
        //echo $id.' and '.$room.' and '.$rtype; die;

        // $id=43;
        // $room=320; 
        // $rtype=216;


        $move=Taken::find()->where(['room_type'=>$rtype])->andWhere(['room_no'=>$room])->andWhere(['id'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();


        $dorooms2=Rooms2::find()->where(['room_number'=>$room,'type'=>$rtype,'cid'=>Yii::$app->user->identity->cid])->one();
        $dorooms2->booked=0;

        $transaction = Yii::$app->db->beginTransaction();
                try {
                    
        // 

        $move->status=2;
        $move->complimentary=NULL;
        if(!$move->save())
        {
            throw new \Exception('could not save to Taken');
        }

        if(!$dorooms2->save())
        {
            throw new \Exception('could not save to dorooms2');
        }


                            $date1=date_create(substr($move->created_at,0,10));
                            $date2=date_create(substr($move->departure,0,10));
                            $diff=date_diff($date2,$date1);
                            $michael=(int)$diff->format("%a");
                            
                                $michael+=1;
                            

                            $price=Inventory::find()->where(['id'=>$rtype])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
                           

                            $total=$michael*$price->price;
                            // echo substr($move->departure,0,10); 
                            echo $michael;

                            $balancer=$total-$move->deposit;
                            // throw new \Exception('could not save to Taken');
                            // die;

                        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

                        $ledger= new Ledger();
                        $ledger->debit=0;
                        $ledger->credit=0;
                        $ledger->department=Yii::$app->user->identity->department;
                        $ledger->cid=Yii::$app->user->identity->cid;
                        $ledger->created_at=date("Y-m-d H:i:s");
                        $ledger->transaction_id=time().'vap'; 
                        $ledger->tlink=$move->transaction_id;
                        $ledger->vendor=(string)$move->guest_id;   
                        $ledger->amount_paid=0;   
                        $ledger->description="Income";
                        $ledger->shop_id=Yii::$app->user->identity->shop_id;
                        $ledger->staff=Yii::$app->user->identity->id;
                        // $ledger->details=json_encode($details);
                        $ledger->ptype=1;
                        $ledger->bank=$config->bank;

                        $ledger->shift=$shift->shift_id;
                        $ledger->stamp=$shift->created_at;
                        if(!$ledger->save())
                        {
                            
                           throw new \Exception( 'could not save to ledger' );  
                           // var_dump($ledger->getErrors()); die;
                        }

            // $inbank=Banks::findOne($config->bank);
            // $inbank->balance+=$total;

            //   if(!$inbank->save())
            //   {
            //       throw new \Exception('could not save to bank');
            //   }


                        // start print

// $connector = new WindowsPrintConnector("mark4");
// $printer = new Printer($connector);

// /* Information for the receipt */
// // $items = array(
// //     new item("Example item #1", "4.00"),
// //     new item("Another thing", "3.50"),
// //     new item("Something else", "1.00"),
// //     new item("A final item", "4.45"),
// // );

// // foreach($positions as $pos)
// // {
//  $shopy=Shops::findOne(Yii::$app->user->identity->shop_id);
//   $items[] = new item($price->name, $michael." @ ".$price->price,$total);
// // }
// $subtotal = new item('Subtotal', '', number_format($total,2));
// // $tax = new item('Vat', '', number_format($total*.10,2));
// $vat=$total*.0;
// $tax = new item('Vat', '', number_format($vat,2));
// $total = new item('Total', '',  number_format($total+=($vat),2), true);
// /* Date is kept the same for testing */
// $date = date('l jS \of F Y h:i:s A');
// // $date = "Monday 6th of April 2015 02:56:25 PM";

// /* Start the printer */
// // $logo = EscposImage::load("resources/escpos-php.png", false);
// $printer = new Printer($connector);

// /* Print top logo */
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// // $printer -> graphics($logo);

// /* Name of shop */
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
// $printer -> text($shopy->name."\n");
// $printer -> selectPrintMode();
// $printer -> text($shopy->address."\n");
// $printer -> feed();

// /* Title of receipt */
// $printer -> setEmphasis(true);
// $printer -> text("SALES INVOICE\n");
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Items */
// $printer -> setJustification(Printer::JUSTIFY_LEFT);
// $printer -> setEmphasis(true);
// // $printer -> text(new item('', '', '$'));
// $printer -> setEmphasis(false);
// foreach ($items as $item) {
//     $printer -> text($item);
// }

// $printer -> feed();

// $printer -> setEmphasis(true);
// $printer -> text($subtotal);
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Tax and total */
// $printer -> text($tax);
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_HEIGHT);
// $printer -> text($total);
// $printer -> selectPrintMode();

// /* Footer */
// $printer -> feed(2);
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// $printer -> text("Thank you for shopping at ".$shopy->name."\n");
// $printer -> text("Please visit again\n");
// $printer -> feed(2);
// $printer -> text($date . "\n");

// /* Cut the receipt and open the cash drawer */
// $printer -> cut();
// $printer -> pulse();

// $printer -> close();


              // end print

        $transaction->commit();
                   

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }

        return $this->redirect(['guests']);
    }

        public function actionChocho()
    {
        ob_start();
        $id=Yii::$app->request->post('id');
        $room=Yii::$app->request->post('rnumber'); 
        $rtype=Yii::$app->request->post('rtype');
        // echo $id.' and '.$room.' and '.$rtype; die;
        $move=Taken::find()->where(['room_type'=>$rtype])->andWhere(['room_no'=>$room])->andWhere(['id'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();


        $vroom=Rooms::find()->where(['room_type'=>$rtype])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        $hold=json_decode($vroom->rooms,true);
        
        // array_push($hold, (int)$room);  
        
        // sort($hold);
        
        
        // $me=array_values($hold);

        $name=Customers::findOne($move->guest_id)->name;

        $transaction = Yii::$app->db->beginTransaction();
                try {
                    
        // $vroom->rooms=json_encode($me);
        // if(!$vroom->save())
        // {
        //     throw new \Exception('could not save to Rooms');
        // }

        // $move->status=2;
        // if(!$move->save())
        // {
        //     throw new \Exception('could not save to Taken');
        // }


                            $date1=date_create(substr($move->created_at,0,10));
                            $date2=date_create(substr($move->departure,0,10));
                            $diff=date_diff($date2,$date1);
                            $michael=(int)$diff->format("%a");
                            
                                // $michael+=1;
                            

                            $price=Inventory::find()->where(['id'=>$rtype])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->price;
                           

                            $total=$michael*$price;
                            // echo substr($move->departure,0,10); 
                            // echo $michael;

                            $balancer=$total-($move->deposit+$move->discount);
                            // throw new \Exception('could not save to Taken');
                            // die;

                        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

                        // $ledger= new Ledger();
                        // $ledger->debit=0;
                        // $ledger->credit=0;
                        // $ledger->department=Yii::$app->user->identity->department;
                        // $ledger->cid=Yii::$app->user->identity->cid;
                        // $ledger->created_at=date("Y-m-d H:i:s");
                        // $ledger->transaction_id='vap'; 
                        // $ledger->rlink=$move->transaction_id;
                        // $ledger->vendor=(string)$move->guest_id;   
                        // $ledger->amount_paid=$balancer;   
                        // $ledger->description="Income";
                        // $ledger->shop_id=Yii::$app->user->identity->shop_id;
                        // // $ledger->details=json_encode($details);
                        // $ledger->ptype=1;
                        // $ledger->bank=$config->bank;
                        // if(!$ledger->save())
                        // {
                            
                        //    throw new \Exception( 'could not save to ledger' );  
                        //    // var_dump($ledger->getErrors()); die;
                        // }

        $transaction->commit();
                   

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }

                    $comp=null;

                    if($move->complimentary==2)
                    {
                        $comp='Reservation';
                    }

        $jane=json_encode(array('days'=>$michael,'arrive'=>date("jS F Y",strtotime($move->created_at)),'depart'=>date('jS F Y',strtotime($move->departure)),'total'=>number_format($price*$michael,2),'balance'=>number_format($balancer,2),'room'=>$room,'rtype'=>Inventory::findOne($rtype)->name,'gname'=>ucwords($name),'deposit'=>number_format($move->deposit,2),'droomt'=>$rtype,'did'=>$id,'rate'=>number_format($price,2),'discount'=>$move->discount,'comp'=>$comp));

        if($move->complimentary==1)
        {
            $jane=json_encode(array('days'=>$michael,'arrive'=>date("jS F Y",strtotime($move->created_at)),'depart'=>date('jS F Y',strtotime($move->departure)),'total'=>'0.00','balance'=>'0.00','room'=>$room,'rtype'=>Inventory::findOne($rtype)->name,'gname'=>ucwords($name),'deposit'=>'0.00','droomt'=>$rtype,'did'=>$id,'rate'=>number_format($price,2),'discount'=>$move->discount,'comp'=>'Complimetary'));
        }
                     // $jane=json_encode(array('days'=>$michael));
        echo $jane;
    }

// [101,102,103,104,105,106,107,108,109,110,111,112]
    
}

class item
{
    private $name;
    private $price;
    private $dollarSign;
    private $quantity;

    public function __construct($name = '', $quantity = '', $price = '', $dollarSign = false)
    {
        $this -> name = $name;
        $this -> price = $price;
        $this -> dollarSign = $dollarSign;
        $this-> quantity = $quantity;
    }

     public function __toString()
    {
        $rightCols = 10;
        $leftCols = 25;
        $centerCols = 10;
        // if ($this -> dollarSign) {
        //     $leftCols = $leftCols / 2 - $rightCols / 2;
        // }
        $left = str_pad($this -> name, $leftCols) ;

        $center = str_pad($this -> quantity, $centerCols) ;

        $sign = ($this -> dollarSign ? '$ ' : '');
        $right = str_pad($this -> price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$center$right\n";
    }
}
