<?php

namespace frontend\modules\retails\controllers;

use Yii;
use frontend\modules\retails\models\Inventory;
use frontend\modules\retails\models\SearchInventory;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use frontend\modules\retails\models\StoresHistory;
use frontend\modules\retails\models\ShopHistory;
use yii\web\UploadedFile;
use frontend\modules\retails\models\Stock;
use frontend\modules\retails\models\Stores;
use frontend\modules\retails\models\Areports;


/**
 * InventoryController implements the CRUD actions for Inventory model.
 */
class InventoryController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                // [
                //     'allow' => true,
                //     'actions' => ['index','dledger'],
                //     //'roles' => ['viewInventoryRole'],
                //     'roles' => ['@'],
                // ],
                [
                    'allow' => true,
                    'actions' => ['create','delete','close_adjust','trading'],
                    'roles' => ['Client Admin'],
                ],
                [
                    'allow' => true,
                    'actions' => ['ad_report','ignore','arequest1','arequest2'],
                    'roles' => ['Store Manager','Shop Manager','Client Admin'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['index','dledger','view','findModel','itemdetails','reorder','update'],
                    'roles' => ['Shop Manager','Client Admin'],
                ],
                   [
                    'allow' => true,
                    'actions' => ['countr','adjust','do_adjust','movement','next'],
                    'roles' => ['@'],
                ],
                     ],
                
                
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Inventory models.
     * @return mixed
     */
    public function actionIndex()
    {
        //  if(Yii::$app->user->identity->role!='Client Admin')
        // {
        //     die('You are not allowed to do this');
        // }

        
        // $this->layout='column2';
        $searchModel = new SearchInventory();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Inventory model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Inventory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    // public function actionCreate()
    // {
    //     $model = new Inventory();

    //     if ($model->load(Yii::$app->request->post()) && $model->save()) {
    //         return $this->redirect(['view', 'id' => $model->id]);
    //     }

    //     return $this->render('create', [
    //         'model' => $model,
    //     ]);
    // }

    /**
     * Updates an existing Inventory model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        //  if(Yii::$app->user->identity->role!='Client Admin')
        // {
        //     die('You are not allowed to do this');
        // }
        
        $model = $this->findModel($id);
        $keep=$model->quantity;
        $img=$model->photo;

        if ($model->load(Yii::$app->request->post())) {

            $model->quantity=$keep;
            $new=UploadedFile::getInstance($model,'photo');
            if(isset($new)){
            if($model->validate())
            {
                if($img!=null && !empty($img))
                {
                // unlink(Yii::$app->basePath . "/web/cats/".$img);
                unlink("cats/".$img);
                }
                $new->saveAs('cats/'.$new->baseName.'.'.$new->extension);
            }
            $model->photo=$new;
        }else{
            $model->photo=$img;
        }
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Inventory model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die('you cannot do this');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Inventory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Inventory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Inventory::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionDledger()
    {
        
        if(Yii::$app->request->post())
      {
        $shop_id=trim(Yii::$app->request->post('shop_id'));
        $category=Yii::$app->request->post('category');
        

        $records = (new \yii\db\Query())
           // ->select(['id'])
            ->from('inventory')
           ->where('countable!=:sam', [':sam' => 2])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            
            if(!empty(Yii::$app->request->post('shop_id')))
            {
                $records=$records->andWhere(['=','shop',$shop_id]);
            }


            if(!empty(Yii::$app->request->post('category')))
            {
                $records=$records->andWhere(['=','category',$category]);
            }

            

            $records=$records->all();
                     
            return $this->render('dledger',['records'=>$records]);

      }

      // 
        $records=Inventory::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['!=','countable',2])->all();
        return $this->render('dledger',['records'=>$records]);
    }

    public function actionItemdetails($id)
    {
        $history=ShopHistory::find()->where(['=','item_id',$id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->all();
        return $this->render('item_details',['history'=>$history]);
    }

    public function actionMovement()
    {
      
      if(Yii::$app->request->post())
      {      
        $from=Yii::$app->request->post('from');
        $to=Yii::$app->request->post('to');
         $querym="select sum(qin) as qin, sum(qout) as qout, created_at, item_id, type, quantity, standing_quantity from shop_history where substr(created_at,1,10)>='".$from."' and  substr(created_at,1,10)<='".$to."' and cid='".Yii::$app->user->identity->cid."'  group by item_id";
        // $querym="select sum(qin) as qin, sum(qout) as qout, created_at, item_id, type, quantity, standing_quantity from shop_history where cid='".Yii::$app->user->identity->cid."'  group by item_id";
         $bobo = Yii::$app->db->createCommand($querym)->queryAll();
//          echo "<pre>";
// var_dump($bobo); die;
// echo "</pre>";
       
          return $this->render('movement',['records'=>$bobo,'datef'=>$from,'tof'=>$to]);
      }else{
      return $this->render('movement');
    }
    }

    public function actionReorder()
    {
        $items=Inventory::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
      
        foreach($items as $item)
        {
            if($item->quantity<$item->reorder)
            {
                $lists[]=array('id'=>$item->id,'name'=>$item->name,'quantity'=>$item->quantity,'shop'=>$item->shop,'reorder'=>$item->reorder);
              
            }
        }
        // var_dump($lists); die;
        return $this->render('reorder',['orders'=>$lists]);
    }

    public function actionCountr()
    {
        $items=Inventory::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
        $count=0;
        foreach($items as $item)
        {
            if($item->quantity<$item->reorder)
            {                
                $count++;
            }
        }

        \Yii::$app->response->data=$count;       
    }

    public function actionDo_adjust()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');
        $manager=Yii::$app->request->post('manager');
        $direction=Yii::$app->request->post('direction');

        $check=Stock::find()->where(['item_id'=>$id,'manager'=>$manager,'status'=>0,'cid'=>Yii::$app->user->identity->cid])->one();
        if($check!=null){
            echo "Stock adjustment request for this item already exists";
            ?>


            <?php
            die;
        }

        $stock= new Stock;
        $stock->direction=$direction;
        $stock->staff=Yii::$app->user->identity->id;
        $stock->manager=$manager;
        $stock->quantity=$quantity;
        $stock->item_id=$id;
        $stock->cid=Yii::$app->user->identity->cid;
        $stock->created_at=date('Y-m-d');
        if($stock->save()){
            echo 1;
        }else{ var_dump($stock->getErrors()); }

    }

    public function actionArequest1()
    {
        $records=Stock::find()->where(['manager'=>2,'status'=>0])->all();
        
        return $this->render('store_requests',['records'=>$records]);
    }

    public function actionArequest2()
    {
        $records=Stock::find()->where(['manager'=>1,'status'=>0])->all();
        
        return $this->render('shop_requests',['records'=>$records]);
    }


    public function actionClose_adjust($id,$direction,$work)
    {
        $pick=Stock::find()->where(['id'=>$id,'status'=>0])->one();
        if($work==1){
            $record=Inventory::find()->where(['id'=>$pick['item_id']])->one();
            $ukept=$record->quantity;
            $uti=$record;
            
            if($direction==1)
            {
                $record->quantity+=$pick['quantity'];
            }

            if($direction==2)
            {
                $record->quantity-=$pick['quantity'];
            }
            $record->save();

            $pick->status=1;
            $pick->save();
            
            // start shophistory things
            
            $shoph = new ShopHistory();
                    $shoph->cid = Yii::$app->user->identity->cid;
                    $shoph->name = $la['item_name'];
                    $shoph->quantity = $la['quantity'];

                    $shoph->price = $uti->price;
                    $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                    $shoph->created_at = date('Y-m-d');
                    $shoph->item_id = $uti->item_id;
                    $shoph->issued_by = Yii::$app->user->identity->id;
                    $shoph->received_by = 0;
                    $shoph->type = Yii::$app->user->identity->id;
                    $shoph->transaction_id = time().rand(1,9)."r";
                    $shoph->countable = $uti->countable;
                    $shoph->standing_quantity = $ukept;
                    
                    
                      if($direction==1){
                        $shoph->type = 1; // store is increasing
                        $shoph->qin = $pick->quantity;
                        }
                         if($direction==2){
                        $shoph->type = 2; // store is decreasing
                        $shoph->qout = $pick->quantity;
                        }


                    if (!$shoph->save()) {
                        
                        throw new \Exception('could not save to shop history');
                      // var_dump($shoph->getErrors()); die;
                        
                    }
            
            
            // end shop history things
            
        }

           if($work==2){
            $record=Stores::find()->where(['id'=>$pick['item_id']])->one();
            $ukept=$record->quantity;
            $uti=$record;
            if($direction==1)
            {
                $record->quantity+=$pick['quantity'];
            }

            if($direction==2)
            {
                $record->quantity-=$pick['quantity'];
            }
            $record->save();

            $pick->status=1;
            $pick->save();

            // start the store history

             $storeh = new StoresHistory();
                        $storeh->name = $uti->name;
                        $storeh->cid = $uti->cid;
                        $storeh->units = $uti->units;
                        $storeh->standing_quantity = $ukept;
                        $storeh->particulars = $uti->particulars;
                        // $storeh->received_date=date('Y-m-d');
                        // $storeh->recieved_by=$uti->recieved_by;
                        $storeh->recieved_by = $staff;
                        $storeh->transaction_id = $uti->transaction_id;
                        $storeh->balance = $uti->balance;
                        $storeh->transaction_quantity = $pick->quantity;
                        $storeh->issued_date = date('Y-m-d');
                        $storeh->description = $uti->description;
                        $storeh->vendor = $hop[0]['vendor'];
                        if($direction==1){
                        $storeh->type = 12; // store is increasing
                        $storeh->qin = $pick->quantity;
                        }
                         if($direction==2){
                        $storeh->type = 11; // store is decreasing
                        $storeh->qout = $pick->quantity;
                        }
                        
                        $storeh->issued_by = Yii::$app->user->identity->id;
                        $storeh->given_to = $uti->given_to;
                        $storeh->item_id = $uti->id;
                        if (!$storeh->save()) {
                            // var_dump($storeh->getErrors()); die;
                            throw new \Exception('could not save to store');
                            
                        }

                            }



                        $areport=new Areports;
                        $areport->item_id=$pick->item_id;
                        $areport->source=$work;
                        $areport->cid=Yii::$app->user->identity->cid;
                        $areport->quantity=$pick->quantity;
                        $areport->created_at=date('Y-m-d');
                        $areport->direction=$direction;
                        if(!$areport->save())
                        {
                            //throw new \Exception('could not save to Areport');
                            var_dump($areport->getErrors()); die;
                        }

            // stop the store history
                        if($work==2){
                        return $this->redirect(['arequest1']);
                    }
                    if($work==1){
                    return $this->redirect(['arequest2']);
                }
        
        
    }


    public function actionAd_report()
    {
        if(Yii::$app->request->post())
        {
           echo  $date1=Yii::$app->request->post('date1');
           echo  $date2=Yii::$app->request->post('date2'); 

           $query="select sum(quantity) as quantity, item_id, source, direction from areports where substr(created_at, 1,10) between '".$date1."' and '".$date2."' and cid='".Yii::$app->user->identity->cid."' group by item_id,direction, source";
           $result=Areports::findBySql($query)->all();
           
        }

        return $this->render('ad_report',['result'=>$result,'date1'=>$date1,'date2'=>$date2]);
    }

    public function actionIgnore($id,$work)
    {
        $rec=Stock::find()->where(['id'=>$id])->one();
        $rec->status=3;
        $rec->save();


          if($work==2){
                return $this->redirect(['arequest1']);
            }
                if($work==1){
                return $this->redirect(['arequest2']);
                }


    }


    public function actionNext()
    {
        if(Yii::$app->request->post()){ 
            $pcategory=Yii::$app->request->post('pcategory');
            $category=Yii::$app->request->post('category');
            $shelf=Yii::$app->request->post('shelf');

            $stock = (new \yii\db\Query())
           // ->select(['id'])
            // ->from('requisitions')
            ->from('inventory')
            ->where('id!=:sam', [':sam' => 0])
            // ->andWhere('amount_paid!=:pa', [':pa' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            // ->andWhere(['concluded'=>1]);
            if(!empty(Yii::$app->request->post('pcategory')))
            {
                $stock=$stock->andWhere(['price_category'=>$pcategory]);
            }

            if(!empty(Yii::$app->request->post('category')))
            {
                $stock=$stock->andWhere(['category'=>$category]);
            }

            if(!empty(Yii::$app->request->post('shelf')))
            {
                $stock=$stock->andWhere(['shelf'=>$shelf]);
            }             
            

            $stock=$stock->all();
            return $this->render('next',['stock'=>$stock]);
        }else{    


        return $this->render('next');
        }
    }
    
    public function actionTrading()
    {
      
      if(Yii::$app->request->post())
      {
        $shop_id=trim(Yii::$app->request->post('shop_id'));
        $category=Yii::$app->request->post('category');
        

        $records = (new \yii\db\Query())
           // ->select(['id'])
            ->from('inventory')
          ->where('countable=:sam', [':sam' => 1])
            ->where('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            
            if(!empty(Yii::$app->request->post('shop_id')))
            {
                $records=$records->andWhere(['=','shop',$shop_id]);
            }


            if(!empty(Yii::$app->request->post('category')))
            {
                $records=$records->andWhere(['=','category',$category]);
            }

            

            $records=$records->all();
                     
            return $this->render('trading',['records'=>$records]);

      }

        $querym="select sum(quantity) as quantity, created_at, price, supply_price, item_id,  name, shop from inventory where cid='".Yii::$app->user->identity->cid."' and countable=1  group by item_id";
         $records = Yii::$app->db->createCommand($querym)->queryAll();

        // $records=Inventory::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['countable'=>1])->all();
        return $this->render('trading',['records'=>$records]);
    }
}
