<?php

namespace frontend\modules\retails\controllers;
use Yii;
use frontend\modules\retails\models\Messages;
use backend\models\User;

use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

class MessagesController extends \yii\web\Controller
{
        public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','mdetails','replymessage'],
                    'roles' => ['@'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        return $this->render('index');
    }


    public function actionMdetails($tid)
    {
    	$message=Messages::find()->where(['=','message_link',$tid])->andWhere(['=','cid',Yii::$app->user->identity->cid])->orderBy('id asc')->all();
    	foreach($message as $mess)
    	{
    		if($mess->status==0)
    		{
    			$mess->status=1;
    			$mess->save();

    		}
    	}


    	return $this->render('mdetails',['message'=>$message,'tid'=>$tid]);
    }

     public function actionReplymessage()
    {
        if(Yii::$app->request->isAjax)
        {
            $message=Yii::$app->request->post('message');
           // $toid=Yii::$app->request->post('toid') ;
            $link=Yii::$app->request->post('link');

            $old=Messages::find()->where(['=','message_link',$link])->one();

            $to=0;
            if($old->to_id==Yii::$app->user->identity->id)
            {
            	$to=$old->from_id;
            }

            if($old->from_id==Yii::$app->user->identity->id)
            {
            	$to=$old->to_id;
            }
           //echo $to;
            if(!isset($subject))
            {
                $subject=substr($message, 0,35);
            }

            if(!empty($message) && !empty($to) && !empty($link))
            {
                $dim= new Messages();
                $dim->cid=Yii::$app->user->identity->cid;
                $dim->from_id=Yii::$app->user->identity->id;
                $dim->to_id=$to;
                $dim->subject=$subject;
                $dim->message=$message;
                $dim->message_link=$link;
                if(!$dim->save())
                {
                    var_dump($dim->getErrors()); die;
                }
               
			
            } 
        }
            $show='';
         $message=Messages::find()->where(['=','message_link',$link])->andWhere(['=','cid',Yii::$app->user->identity->cid])->orderBy('id asc')->all();
                 $align=''; $laytext=''; $color='#eee';
                 foreach($message as $mes)
				{ 
					if($mes->to_id==Yii::$app->user->identity->id){ $align='left'; $color='#E1E7FD'; }else{ $align='right'; $laytext='right';  $color='#eee';}
				
			$show.='<div class="dsender" style="display:block; margin-bottom:20px; float:'.$align.' text-align:<?= $laytext ?>; background-color:'. $color.'"><span style="color:blue">'. User::getName($mes->from_id)."</span> ".$mes->message.'</div>';

				
				}
					\Yii::$app->response->data=$show;
        
    }

}
