<?php

namespace frontend\modules\retails\controllers;

use Yii;
use frontend\modules\retails\models\Reservations;
use frontend\modules\retails\models\ReservationsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use frontend\modules\retails\models\Banks;
use frontend\modules\retails\models\Shops;
use frontend\modules\retails\models\Config;
use frontend\modules\retails\models\Ledger;
use frontend\modules\retails\models\Retails;
use frontend\modules\retails\models\Charts;
use frontend\modules\retails\models\Entry;
use frontend\modules\retails\models\Customers;
use frontend\modules\retails\models\Shifts;


require Yii::getAlias('@vendor') . '/mike42/escpos-php/autoload.php';
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
        use Mike42\Escpos\Printer;
         

date_default_timezone_set('Africa/Lagos');

/**
 * ReservationsController implements the CRUD actions for Reservations model.
 */
class ReservationsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Reservations models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ReservationsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Reservations model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Reservations model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        

      

        $shift=Shifts::find()->where(['shift_name'=>Yii::$app->user->identity->id,'status'=>1])->one();
        if($shift==null){
          die('You do not have an open shift to sell. Please click the back button');
        }


        $model = new Reservations();


        if ($model->load(Yii::$app->request->post())) {

            if(!$model->save())
            {
                throw new \Exception( 'could not save to ledger' );  
                // var_dump($model->getErrors()); die;
            }

           
            // start money things

             $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

            $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

            $inbank=Banks::findOne($config->bank);
            
            $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 


                $total=$model->amount_paid;
                $transaction_id=time().rand(1,9); 
                $customer=$model->contact_person;
                $payment=$model->payment;
                $discount=$model->discount;

                $transaction = Yii::$app->db->beginTransaction();
                try {

                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                
                $ledger->vendor=$customer;   
                $ledger->amount_paid=$total;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode(array(array('item_name'=>'Reservation','price'=>$model->amount_paid,'quantity'=>1)));
                $ledger->ptype=1;
                $ledger->bank=$config->bank;
                $ledger->transaction_id=$transaction_id;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->payment_method=$payment;
                $ledger->discount=$discount;
                $ledger->shift=$shift->shift_id;
                if(!$ledger->save())
                {
                    
                   throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); //die;
                }



        $to_use=Retails::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id,'cid'=>Yii::$app->user->identity->cid])->one();
       

        $chart_account=$to_use->receivable;
        $chart_account2=$to_use->income_head;


        $ac1=Charts::findOne($to_use->receivable);
        $ac2=Charts::findOne($to_use->income_head);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group; 

        $entry_type=1;

        

      
      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $total=($total*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $total=($total*-1);
      } 

      $enter = new Entry;
        $enter->amount=$total;
        $enter->entry_type=1;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$ledger->id;
        $enter->dsource='led';
        $enter->transaction_id=$transaction_id;
        $enter->lid=$ledger->id;
        
        if(!$enter->save())
        {
          // var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }

        // second entry

        $total=abs($total);
        // entry 2
        $entry_type2=2;
      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $total=($total*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $total=($total*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$total;
        $enter2->entry_type=2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$ledger->id;
        $enter2->dsource='led';
        $enter2->transaction_id=$transaction_id;
        $enter2->lid=$ledger->id;
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }

            // end money things

        // start printing receipt

        // foreach($positions as $pos)
        // {
          $items[] = new item('Reservation', '1', "@ ".$model->amount_paid);
        //}

        $ready=Shops::findOne(Yii::$app->user->identity->shop_id);


        // $connector = new WindowsPrintConnector($ready->printer);
        // $printer = new Printer($connector);

        // $subtotal = new item('Subtotal', '', number_format($total2,2));
        // // $tax = new item('Vat', '', number_format($total*.10,2));
        // $vat=$total2*.10;
        // $tax = new item('Vat', '', number_format($vat,2));
        // $total2 = new item('Total', '',  number_format($total2,2), true);
        // /* Date is kept the same for testing */
        // $date = date('l jS \of F Y h:i:s A');
        // // $date = "Monday 6th of April 2015 02:56:25 PM";

        // /* Start the printer */
        // // $logo = EscposImage::load("resources/escpos-php.png", false);
        // $printer = new Printer($connector);

        // /* Print top logo */
        // $printer -> setJustification(Printer::JUSTIFY_CENTER);
        // // $printer -> graphics($logo);

        // /* Name of shop */
        // $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        // $printer -> text($shopy->name."\n");
        // $printer -> selectPrintMode();
        // $printer -> text($shopy->address."\n");
        // $printer -> feed();

        // /* Title of receipt */
        // $printer -> setEmphasis(true);
        // $printer -> text("SALES RECEIPT\n");
        // $printer -> text("RECEIPT NO: ".$transaction_id."\n");
        // $printer -> setEmphasis(false);
        // $printer -> feed();
        // $printer -> text("Waiters/Customers Name: ".ucwords(Customers::findOne($customer)->name)."\n");
        // $printer -> feed();
        // /* Items */
        // $printer -> setJustification(Printer::JUSTIFY_LEFT);
        // $printer -> setEmphasis(true);
        // // $printer -> text(new item('', '', '$'));
        // $printer -> setEmphasis(false);
        // foreach ($items as $item) {
        //     $printer -> text($item);
        // }

        // $printer -> feed();

        // $printer -> setEmphasis(true);
        // $printer -> text($subtotal);
        // $printer -> setEmphasis(false);
        // $printer -> feed();

        // /* Tax and total */
        // $printer -> text($tax);
        // $printer -> selectPrintMode(Printer::MODE_DOUBLE_HEIGHT);
        // $printer -> text($total2);
        // $printer -> selectPrintMode();

        // /* Footer */
        // $printer -> feed(2);
        // $printer -> setJustification(Printer::JUSTIFY_CENTER);
        // $printer -> text("Thank you for your patronage.\n");

        // $printer -> feed(2);
        // $printer -> text($date . "\n");

        // /* Cut the receipt and open the cash drawer */
        // $printer -> cut();
        // $printer -> pulse();

        // $printer -> close();


         $transaction->commit();
                   

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }


              // end print
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Reservations model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        die('cant do');
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Reservations model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
       die('not allowed');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Reservations model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Reservations the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Reservations::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}

class item
{
    private $name;
    private $price;
    private $dollarSign;
    private $quantity;

    public function __construct($name = '', $quantity = '', $price = '', $dollarSign = false)
    {
        $this -> name = $name;
        $this -> price = $price;
        $this -> dollarSign = $dollarSign;
        $this-> quantity = $quantity;
    }

     public function __toString()
    {
        $rightCols = 10;
        $leftCols = 25;
        $centerCols = 10;
        // if ($this -> dollarSign) {
        //     $leftCols = $leftCols / 2 - $rightCols / 2;
        // }
        $left = str_pad($this -> name, $leftCols) ;

        $center = str_pad($this -> quantity, $centerCols) ;

        $sign = ($this -> dollarSign ? '$ ' : '');
        $right = str_pad($this -> price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$center$right\n";
    }

}
