<?php

namespace frontend\modules\retails\controllers;

use Yii;
use frontend\modules\retails\models\Rooms;
use frontend\modules\retails\models\RoomsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use frontend\modules\retails\models\Taken;
use frontend\modules\retails\models\Inventory;
use frontend\modules\retails\models\Ledger;
use frontend\modules\retails\models\Accounts;
use frontend\modules\retails\models\Retails;
use frontend\modules\retails\models\Entry;
use frontend\modules\retails\models\Customers;

date_default_timezone_set('Africa/Lagos');

/**
 * RoomsController implements the CRUD actions for Rooms model.
 */
class RoomsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Rooms models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RoomsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Rooms model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Rooms model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Rooms();

        if ($model->load(Yii::$app->request->post())) {

        $room=Rooms::find()->where(['room_type'=>$model->room_type])->one();
        if($room!=null)
        {
            die('You have already created room numbers for these category of rooms');
        }

        for($x=1; $x<=$model->total_rooms; $x++)
        {
            $looms[]=($model->room_range+$x);
        }

        $model->rooms=json_encode($looms);



            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Rooms model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

        // $room=Rooms::find()->where(['room_type'=>$model->room_type])->one();
        // if($room!=null)
        // {
        //     die('You have alread created room numbers for this room');
        // }

        for($x=1; $x<=$model->total_rooms; $x++)
        {
            $looms[]=($model->room_range+$x);
        }
        $model->rooms=json_encode($looms);

        $model->save();

            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Rooms model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Rooms model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Rooms the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Rooms::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionGetrooms()
    {
        ob_start();
        $room=Yii::$app->request->post('rooms');
        $query=Rooms::find()->where(['room_type'=>$room])->one();
        $voom=json_decode($query->rooms,true);

        foreach($voom as $vom)
        {
            ?>

<span style="float:left;"><?= Html::img('@web/beds/bed2.jpg', ['class' => 'pull-center img-responsive','style'=>'height:70px; width:auto;']) ?><?= $vom ?></span>

            <?php
        }
    }

    public function actionGetrooms2()
    {
        $no=Yii::$app->request->post('no');
        $rooms=Rooms::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['room_type'=>$no])->one();
        
        $roo=json_decode($rooms->rooms,true);
       echo Html::dropDownList('room',null, $roo,['class'=>'form-control camp','prompt'=>'','id'=>'roomy','style'=>'background-color:red; color:#fff;']);
         
    }

    // get account

    public function actionDobill()
    {
        $no=Yii::$app->request->post('no');
        if($no==2){
        // $account=Accounts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
            $account=Customers::find()->where(['cid'=>Yii::$app->user->identity->cid,'cctype'=>2])->all();

        $one=array();
        $two=array();

        foreach($account as $ac1)
        {
            array_push($one, $ac1->id);
        }

         foreach($account as $ac2)
        {
            array_push($two, $ac2->name);
        }


        //$roo=json_decode($rooms->rooms,true);
        $get=array_combine($one,$two);
       echo Html::dropDownList('account',null, $get,['class'=>'form-control','prompt'=>'','id'=>'account1','style'=>'']);
   }
         
    }

    public function actionExtendit()
    {
        $done=0;
        $id=Yii::$app->request->post('id');
        $date=Yii::$app->request->post('datex');
        $record=Taken::findOne($id);

        // $id=66;
        // $date='2020-09-30';
        // $record=Taken::findOne(66);
        // echo $record->id; die;

        // check that date is not same as checkin or created_at date

        if(substr($record->created_at,0,10)>=substr($date, 0,10))
        {
            die('Please select a valid departure date');
        }

        // work with old date
        $date11=date_create(substr($record->created_at,0,10));
        $date21=date_create(substr($record->departure,0,10));
        $diff2=date_diff($date21,$date11);
        $michael2=(int)$diff2->format("%a");

        // start to get new date

        $old_date=$record->departure;

        $new_date=$date;
        $created=substr($record->created_at,1,10);
       

        // start set new total

        $date1=date_create($created);
        $date2=date_create($date);
        $diff=date_diff($date2,$date1);
        $michael=(int)$diff->format("%a");

       // $michael+=1; // i removed plus one addition for michael in taken but its needed here for now



        $price=Inventory::find()->where(['id'=>$record['room_type']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->price;

       // $internal_discount=
        $total=$michael*$price;



        $transaction = Yii::$app->db->beginTransaction();
        try {

if($record->complimentary!=2){

        // update ledger total
           if($record->complimentary!=1){
            

        $new_total=Ledger::find()->where(['transaction_id'=>$record->transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();

        $unit_discount=($new_total->discount/$michael2);

        $got_discount=$unit_discount*$michael;

        //$total-=$new_total->discount; // set new value of total
        $total-=$got_discount;

        $new_total->credit=$total;
        $new_total->details=null;
        $new_total->discount=$got_discount;
        if($record->complimentary!=1){
        if(!$new_total->save())
        {
            throw new \Exception('could not save entry1');
        }
    }
}
        // more update
if($record->complimentary!=1){
        $close=Ledger::find()->where(['transaction_id'=>$record->transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        $type_text=Inventory::find()->where(['id'=>$record['room_type']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->name;
        $close->details=json_encode([['shop_id'=>Yii::$app->user->identity->shop_id,'price'=>$price,'quantity'=>$michael,'item_name'=>$type_text,'hotel'=>1]]);
        if($record->complimentary!=1){
        if(!$close->save())
        {
            throw new \Exception('could not save entry1');
        }
    }
}

        
$new_string=$type_text."- ".$michael." @ ".$price."= ".$price*$michael;
        // end set new total

        // update entry values

         $to_use=Retails::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id,'cid'=>Yii::$app->user->identity->cid])->one();
         
         if($record->complimentary!=1){
         $receive_update=Entry::find()->where(['transaction_id'=>$record->transaction_id,'chart_account'=>$to_use->receivable])->one();
         $receive_update->amount=$total;
         if($record->complimentary!=1){
         if(!$receive_update->save())
         {
            throw new \Exception('could not save entry1');
         }
     }
 }

        if($record->complimentary!=1){
         $income_update=Entry::find()->where(['transaction_id'=>$record->transaction_id,'chart_account'=>$to_use->income_head])->one();
         
         $income_update->amount=$total;
         if($record->complimentary!=1){
         if(!$income_update->save())
         {
            throw new \Exception('could not save entry1');
         }
     }
 }

        $record->departure=$date;
        $record->discount=$got_discount;
        if(!$record->save())
        {
           throw new \Exception('could not save entry1');
        }else{
             $done=1;
        }

} // end of


// run if complimentary is 2 that means reservation


        if($record->complimentary==2){

                      
            

        $new_total=Ledger::find()->where(['transaction_id'=>$record->transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
//$old_credit=$new_total->credit; // will be used to updated credit later down in this page

        $unit_discount=($new_total->discount/$michael2);

        $got_discount=$unit_discount*$michael;

        //$total-=$new_total->discount; // set new value of total
        $total-=$got_discount;
        $total-=$new_total->reservation_deposit;

        $new_total->credit=$total;
        $new_total->details=null;
        $new_total->discount=$got_discount;
       
        if(!$new_total->save())
        {
            throw new \Exception('could not save entry1');
        }
    

        // more update

        $close=Ledger::find()->where(['transaction_id'=>$record->transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        $type_text=Inventory::find()->where(['id'=>$record['room_type']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->name;
        $close->details=json_encode([['shop_id'=>Yii::$app->user->identity->shop_id,'price'=>$price,'quantity'=>$michael,'item_name'=>$type_text,'hotel'=>1]]);
     
        if(!$close->save())
        {
            throw new \Exception('could not save entry1');
        }
    


        
$new_string=$type_text."- ".$michael." @ ".$price."= ".$price*$michael;
        // end set new total

        // update entry values

         $to_use=Retails::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id,'cid'=>Yii::$app->user->identity->cid])->one();
         
         
         $receive_update=Entry::find()->where(['transaction_id'=>$record->transaction_id,'chart_account'=>$to_use->receivable])->one();
         $receive_update->amount=$total;
         
         if(!$receive_update->save())
         {
            throw new \Exception('could not save entry1');
         }
     
 

        
         $income_update=Entry::find()->where(['transaction_id'=>$record->transaction_id,'chart_account'=>$to_use->income_head])->one();
         
         $income_update->amount=$total;
        
         if(!$income_update->save())
         {
            throw new \Exception('could not save entry1');
         }
     
 

        $record->departure=$date;
        $record->discount=$got_discount;
        if(!$record->save())
        {
           throw new \Exception('could not save entry1');
        }else{
             $done=1;
        }

        }

        $transaction->commit();
   
            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; 
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; 
            }

        echo json_encode(array('done'=>$done,'idx'=>$id,'newdate'=>$date,'textt'=>$total,'new_string'=>$new_string));
    }


}
