<?php
namespace frontend\modules\retails\controllers;

use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\modules\retails\models\PasswordResetRequestForm;
use frontend\modules\retails\models\ResetPasswordForm;
use frontend\modules\retails\models\SignupForm;
use frontend\modules\retails\models\ContactForm;

use backend\models\Tasks;
use backend\models\Workflow;
use backend\models\RequisitionTypes;
use frontend\modules\retails\models\Requisitions;

use yii\helpers\Html;
use yii\widgets\ActiveForm;

use yii\helpers\ArrayHelper;
use unclead\multipleinput\MultipleInput;
use frontend\modules\retails\models\Messages;
use backend\models\User;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
               // 'only' => ['logout', 'signup'],
                'rules' => [
                      [
                      'actions' => ['login','index','log2','RequestPasswordReset','ResetPassword','request-password-reset','reset-password'],
                      'allow' => true,
                      'roles' => ['?'],
                    ],
                     [
                      'actions' => ['reset'],
                      'allow' => true,
                      'roles' => ['Client Admin'],
                    ],
                    [
                       // 'actions' => ['signup','login','about','error'],
                        'actions' => ['about','error','index','login'],
                        'allow' => true,
                        'roles' => ['?','@'],
                    ],
                   
                    [
                        'actions' => ['logout','start','newrequisition','instruments','newsales',
                        'newsales2','sendmessage','addmessage',
                        'newrequisition2',
                        'contact',
                        'dashboard','sendmessage','sendm2','admin_dash',
                        'outflow','changepass'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],                   
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */
    public function actionIndex()
    {
        // $this->layout='column1';
        // return $this->render('index');

         if (!Yii::$app->user->isGuest) {
            //return $this->goHome();
           return $this->redirect(['requisitions/land']);
        }
      $model = new LoginForm();
       $this->layout='Log2';
        return $this->render('log2',['model'=>$model]);
    }

    /**
     * Logs in a user.
     *
     * @return mixed
     */
    public function actionLogin()
    {
        $this->layout='Log2';
        if (!Yii::$app->user->isGuest) {
            //return $this->goHome();
           return $this->redirect(['requisitions/land']);
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            //return $this->goBack();
          if(Yii::$app->user->identity->role=='clientAdmin')
          {
            return $this->redirect(array('admin_dash'));
          }
            return $this->redirect(['dashboard']);
        } else {
            $model->password = '';

            return $this->render('log2', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return mixed
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
                Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
            } else {
                Yii::$app->session->setFlash('error', 'There was an error sending your message.');
            }

            return $this->refresh();
        } else {
            return $this->render('contact', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Displays about page.
     *
     * @return mixed
     */
    public function actionAbout()
    {
        $task=Tasks::find()->all(); //var_dump($task);
        return $this->render('about',['tasks'=>$task]);
    }

    /**
     * Signs user up.
     *
     * @return mixed
     */
    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                if (Yii::$app->getUser()->login($user)) {
                    return $this->goHome();
                }
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }
 
    /**
     * Requests password reset.
     *
     * @return mixed
     */

    public function actionRequestPasswordReset()
    {
        $this->layout='column1';
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for the provided email address.');
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionResetPassword($token)
    {
        $this->layout='column1';
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }

      public function actionStart()
    {
        $model = new Requisitions();
        return $this->render('start',['model'=>$model]);
    }

     public function actionNewrequisition()
    {
       $selected_text=$_POST['selected_text'];
       $selected_id=$_POST['selected_id'];       
       $model= new Requisitions();

       $resource_type=Tasks::findOne($selected_id);
       
     
      

       $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       $flow_id=$flo->id;
       $full_flow=$flo->int_workflow;
       
       $flow_array=explode(',', $flo->int_workflow);
       $start_flow=$flow_array[0];

       $instrument_array=explode(',', $flo->instrument);
       $instrument=$instrument_array[0];
       
        if($resource_type->task_type==1)
       {     

       $forma='';
       $form = ActiveForm::begin(['action'=>['requisitions/create'],]);
       
    

  $forma.="<div style='margin-top:30px; display:block;' class='requisitions-form'>
    <h4 style='color:blue; text-transform:uppercase;'>". ucwords($selected_text)."</h4>";
    
    $forma.=$form->field($model, 'workflow_id')->hiddenInput(['value'=>$flow_id,'id'=>'flowid'])->label(false).

     $form->field($model, 'status')->hiddenInput(['value'=>$start_flow,'id'=>'sta'])->label(false).

    $form->field($model, 'instrument')->hiddenInput(['value'=>$instrument])->label(false).
    $form->field($model, 'not_seen')->hiddenInput(['value'=>$full_flow])->label(false).
    $form->field($model, 'task_type')->hiddenInput(['value'=>$resource_type->task_type])->label(false);
    


$note=json_encode(array('forma'=>$forma,'tag'=>1));
echo $note;

 }

 if($resource_type->task_type==2){
        
$forma='';
       $form = ActiveForm::begin(['action'=>['requisitions/create'],]);
    
$forma.="<h1>Store</h1>

<div>
    <div>"
 .Html::textInput('item','',['class'=>'form-control','onkeyup'=>'getItem()','id'=>'item'])."
    </div>
    <div id=\"item_list\">

    </div>

    <div id=\"invoice\">

    </div>



</div>";

 $forma.=$form->field($model, 'workflow_id')->textInput(['value'=>$flow_id,'id'=>'flowid'])->label(false).

     $form->field($model, 'status')->textInput(['value'=>$start_flow, 'id'=>'status1'])->label(false).

    $form->field($model, 'instrument')->textInput(['value'=>$instrument, 'id'=>'instrument'])->label(false).
    $form->field($model, 'not_seen')->textInput(['value'=>$full_flow,'id'=>'seen'])->label(false).
     $form->field($model, 'task_type')->textInput(['value'=>$resource_type->task_type])->label(false);

       $note=json_encode(array('forma'=>$forma,'tag'=>2));
        echo $note; 
       }

       if($resource_type->task_type==3)
       {     

       $forma='';
       $form = ActiveForm::begin(['action'=>['requisitions/create'],]);
       
    

  $forma.="<div style='margin-top:30px; display:block;' class='requisitions-form'>
    <h4 style='color:blue; text-transform:uppercase;'>". ucwords($selected_text)."</h4>";
    
    $forma.=$form->field($model, 'workflow_id')->hiddenInput(['value'=>$flow_id,'id'=>'flowid'])->label(false).
     $form->field($model, 'workflow_id')->hiddenInput(['value'=>$flow_id,'id'=>'flowid2'])->label(false).

     $form->field($model, 'status')->hiddenInput(['value'=>$start_flow,'id'=>'status2'])->label(false).

    $form->field($model, 'instrument')->hiddenInput(['value'=>$instrument,'id'=>'instrument2'])->label(false).
    $form->field($model, 'not_seen')->hiddenInput(['value'=>$full_flow,'id'=>'seen2'])->label(false).
    $form->field($model, 'task_type')->hiddenInput(['value'=>$resource_type->task_type,'id'=>'task_type'])->label(false);
    


$note=json_encode(array('forma'=>$forma,'tag'=>3));
echo $note;

 }
    }

  

     public function actionNewsales()
    {
       $selected_text=$_POST['selected_text'];
       $selected_id=$_POST['selected_id'];       
       $model= new Requisitions();

      $resource_type=Tasks::findOne($selected_id);
     
      

       $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       $flow_id=$flo->id;
       $full_flow=$flo->int_workflow;
       
       $flow_array=explode(',', $flo->int_workflow);
       $start_flow=$flow_array[0];

       $instrument_array=explode(',', $flo->instrument);
       $instrument=$instrument_array[0];
             

  $show="<div>

 ".Html::textInput('customer', null, ['id'=>'customer','class'=>'form-control','style'=>'margin-top:30px;','placeholder'=>'Enter Customer Name'])."
    </div>   
    
<h1>Store</h1>

<div>
    <div>".
Html::textInput('item','',['class'=>'form-control','onkeyup'=>'getItem()','id'=>'item'])."
    </div>


        <div id=\"item_list\">

    </div>


  <div style=\'margin-top:30px; display:block;\' class='requisitions-form'>
    <h4 style='color:blue; text-transform:uppercase;'>".ucwords($selected_text). "</h4>"
    
  

    .Html::hiddenInput('workflow_id', $flow_id, ['id'=>'flowid2','class'=>'form-control']).
    Html::hiddenInput('status', $start_flow, ['id'=>'status2','class'=>'form-control']).
    Html::hiddenInput('instrument', $instrument, ['id'=>'instrument2','class'=>'form-control']).
    Html::hiddenInput('not_seen', $full_flow, ['id'=>'seen2','class'=>'form-control']).
    Html::hiddenInput('task_type', $resource_type->task_type, ['id'=>'task_type','class'=>'form-control'])."
    <div id=\"invoice\">

    </div>

    <div>"
      .Html::button('Checkout55',['class'=>'btn btn-success','onclick'=>'make_sale()','id'=>'button1'])."
       ".Html::button('Clearcart',['class'=>'btn btn-danger','onclick'=>'clearcart()','id'=>'button55'])."
  </div>



</div>";
\Yii::$app->response->data=$show;

    }



      public function actionNewsales2()
    {
       ob_start();
       $selected_text=$_POST['selected_text'];
       $selected_id=$_POST['selected_id']; 
       //$selected_id=Yii::$app->request->post('selected_id');   
       $model= new Requisitions();

      $resource_type=Tasks::findOne($selected_id);
     
      

       $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       $flow_id=$flo->id;
       $full_flow=$flo->int_workflow;
       
       $flow_array=explode(',', $flo->int_workflow);
       $start_flow=$flow_array[0];

       $instrument_array=explode(',', $flo->instrument);
       $instrument=$instrument_array[0];
       ?>        

    
    
<h1>Stock Items</h1>

<div>
    <div>
<?= Html::textInput('item','',['class'=>'form-control','onkeyup'=>'getItem2()','id'=>'item2']) ?>
    </div>
        <div id="item_list2">

    </div>


  <div style='margin-top:30px; display:block;' class='requisitions-form'>
    <h4 style='color:blue; text-transform:uppercase;'><?= ucwords($selected_text) ?></h4>
    
  

    <?= Html::hiddenInput('workflow_id', $flow_id, ['id'=>'flowid2','class'=>'form-control']) ?>
    <?= Html::hiddenInput('status', $start_flow, ['id'=>'status2','class'=>'form-control']) ?>
    <?= Html::hiddenInput('instrument', $instrument, ['id'=>'instrument2','class'=>'form-control']) ?>
    <?= Html::hiddenInput('not_seen', $full_flow, ['id'=>'seen2','class'=>'form-control']) ?>
    <?= Html::textInput('task_type', $resource_type->task_type, ['id'=>'task_type','class'=>'form-control']) ?>
  




    <div id="invoice2">

    </div>

    <div>
      <?= Html::button('Checkout',['class'=>'btn btn-success','onclick'=>'make_sale2()','id'=>'button2']) ?>
          
  </div>



</div>

<?php
    }

 

     public function actionInstruments()
        {
             
            return $this->render('instruments');
        }


    public function actionDashboard()
    {
        // if(Yii::$app->user->identity->role=='Client Admin')
        // {
        //   return $this->redirect(['admin_dash']);
        // }


        if(Yii::$app->user->identity->place!=1 && Yii::$app->user->identity->role!='Client Admin' && Yii::$app->user->identity->role!='accounts')
        {
          return $this->redirect(['requisitions/land']);
        }

        $this->layout='Dash';
        // $this->layout='column2';
        $pending_req_count=Requisitions::find()->where(['!=','concluded',1])->andWhere(['!=','rejected',1])->andWhere(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid])->count();


        $rejected_req=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid,'rejected'=>1])->count();
         
   
       // $sales=Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','SUBSTR(created_at,1,7)',date('Y-m')])->andWhere(['=','concluded',1])->andWhere(['task_type'=>2])->all();
       // $total=0;
       // $x=0;
      
       // foreach($sales as $sale)
       // {
       // // var_dump($sale->requested_item); 
       // //  var_dump($total);
       //  foreach(json_decode($sale->requested_item,true) as $item)
       //  {
       //      $total+=$item['total'];

       //  }
        
       // }

        $today_sales = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:pp',[':pp'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,10)=:day',[':day'=>date('Y-m-d')])
            ->andWhere(['!=','id',1])
            ->sum('credit');

            $total=$today_sales;
      
     
  
        $atcount=Requisitions::find()->where(['status'=>Yii::$app->user->identity->id,'cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','rejected',1])->andWhere(['=','concluded',0])->count();
        $total_req=Requisitions::find()->where(['cid'=>Yii::$app->user->identity->cid])->count();
        $staff_count=User::find()->where(['=','cid',Yii::$app->user->identity->cid])->count();
         
  
        $mecount=Messages::find()->where(['=','to_id',Yii::$app->user->identity->id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',0])->count();
         // $g_sales = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]);
           $g_sales = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,7)=:month',[':month'=>date('Y-m')])
            ->sum('credit');

             $g_expense = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,7)=:month',[':month'=>date('Y-m')])
            ->sum('debit');
       // get the total number of users
      // var_dump($g_expense); die;
      
      
      if($g_expense===NULL)
      {
          $g_expense=0;
      }
       if($g_sales===NULL)
      {
          $g_sales=0;
      }
    
      
    //    
   
        return $this->render('dashboard',['pending_req_count'=>$pending_req_count,'total_sales'=>$total,
            'rejected'=>$rejected_req,'staff'=>$staff_count,'g_sales'=>$g_sales,
            'g_expense'=>$g_expense,'mcount'=>$mecount,'total_req'=>$total_req]);
    }

    public function actionNewrequisition2()
    {
         $model=new Requisitions();
         $form = ActiveForm::begin(); 

         echo $form->field($model, 'title')->textInput(['id'=>'title2']);
         echo $form->field($model, 'requested_item')->widget(MultipleInput::className(), [
            'id' => 'ajform_id78',
            'max' => 100,

   

    
    'columns' => [
     
        // [
        //     'name'  => 'day',
        //     'type'  => \kartik\date\DatePicker::className(),
        //     'title' => 'Day',
        //     'value' => function($data) {
        //         return $data['day'];
        //     },
        //     'items' => [
        //         '0' => 'Saturday',
        //         '1' => 'Monday'
        //     ],
        //     'options' => [
        //         'pluginOptions' => [
        //             'format' => 'dd.mm.yyyy',
        //             'todayHighlight' => true
        //         ]
        //     ]
        // ],
         [
            'name'  => 'item_name',
            'title' => 'Item_name',
            'enableError' => true,
            'options' => [
                'class' => 'input-priority'
            ]
        ],
         [
            'name'  => 'details',
            'title' => 'Description',
            'enableError' => true,
            'options' => [
                'class' => 'input-priority'
            ]
        ],
        [
            'name'  => 'quantity',
            'title' => 'Quantity',
            'enableError' => true,
            'options' => [
                'class' => 'input-priority',
                'id'=>'qty',
               // 'onkeyup'=>'addit('.Html::getInputId($model,"quantity").')'
                'onkeyup'=>'grass()'
                
            ]
        ],
        [
            'name'  => 'amount',
            'title' => 'Unit Cost',
            'enableError' => true,
            'options' => [
                'class' => 'input-priority',
                'id'=>'price',
               //'onkeyup'=>'$("input").keyup(function(){ alert("hello"); })'
                
            ]
        ],
         [
            'name'  => 'total',
            'title' => 'Total',
            'enableError' => true,
            'options' => [
                'class' => 'input-priority',
                'id'=>'total',
                'readonly'=>'readonly'
            ]
        ],
    ]
 ]);
ActiveForm::end();

    }


    public function actionSendmessage()
    {
        $this->layout='Dash';
        return $this->render('sendmessage');
    }

    public function actionSendm()
    {
        $this->layout='Dash';
        return $this->render('sendm');
    }


      public function actionSendm1()
    {
        $this->layout='Dash';
        return $this->render('sendm1');
    }

      public function actionSendm2()
    {
        // $this->layout='Dash';
      $this->layout='column2';
        $messages=Messages::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','to_id',Yii::$app->user->identity->id])->orderBy(['created_at'=>SORT_DESC])->groupBy('message_link')->all();
        return $this->render('sendm2',['messages'=>$messages]);
    }

    public function actionAddmessage()
    {
        if(Yii::$app->request->isAjax)
        {
            $message=Yii::$app->request->post('message');
            $subject=Yii::$app->request->post('subject') ;
            $toid=Yii::$app->request->post('toid');
           // _csrf=$_POST['csr'];
            if(empty($subject))
            {
                $subject=substr($message, 0,35);
            }

            if(!empty($message) && !empty($toid))
            {
                $dim= new Messages();
                $dim->cid=Yii::$app->user->identity->cid;
                $dim->from_id=Yii::$app->user->identity->id;
                $dim->to_id=$toid;
                $dim->subject=$subject;
                $dim->message=$message;
                $dim->message_link=time().rand(1,9).rand(2,9);
                if(!$dim->save())
                {
                    var_dump($dim->getErrors()); die;
                }
                //echo 'saved';
                \Yii::$app->response->data='saved';
            } 
        }
        
    }


    public function actionAdmin_dash()
    {
       $this->layout='Dash';
        $pending_req_count=Requisitions::find()->where(['!=','concluded',1])->andWhere(['!=','rejected',1])->andWhere(['cid'=>Yii::$app->user->identity->cid])->count();


        $rejected_req=Requisitions::find()->where(['cid'=>Yii::$app->user->identity->cid,'rejected'=>1])->count();
                
      

        $today_sales = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:pp',[':pp'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,10)=:day',[':day'=>date('Y-m-d')])
            ->andWhere(['!=','id',1])
            ->sum('credit');

            $total=$today_sales;
      
     
  
        $atcount=Requisitions::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','rejected',1])->andWhere(['=','concluded',0])->count();
        $total_req=Requisitions::find()->where(['cid'=>Yii::$app->user->identity->cid])->count();
        $staff_count=User::find()->where(['=','cid',Yii::$app->user->identity->cid])->count();
         
  
        $mecount=Messages::find()->where(['=','to_id',Yii::$app->user->identity->id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',0])->count();
         // $g_sales = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]);
           $g_sales = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,7)=:month',[':month'=>date('Y-m')])
            ->sum('credit');

             $g_expense = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
           // ->where('id!=:sam', [':sam' => 0])
            ->Where('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('SUBSTR(created_at,1,7)=:month',[':month'=>date('Y-m')])
            ->sum('debit');
       // get the total number of users
      // var_dump($g_expense); die;
      
      
      if($g_expense===NULL)
      {
          $g_expense=0;
      }
       if($g_sales===NULL)
      {
          $g_sales=0;
      }
    
      
    //    
   
        return $this->render('admin_dash',['pending_req_count'=>$pending_req_count,'total_sales'=>$total,
            'rejected'=>$rejected_req,'staff'=>$staff_count,'g_sales'=>$g_sales,
            'g_expense'=>$g_expense,'mcount'=>$mecount,'total_req'=>$total_req]);
    }


    public function actionOutflow()
    {
      $selected_text=$_POST['selected_text'];
       $selected_id=$_POST['selected_id'];       
       $model= new Requisitions();

       $resource_type=Tasks::findOne($selected_id);
       
     
      

       $flo=Workflow::find()->where(['cid'=>Yii::$app->user->identity->cid,'task_id'=>$selected_id])->one();
       $flow_id=$flo->id;
       $full_flow=$flo->int_workflow;
       
       $flow_array=explode(',', $flo->int_workflow);
       $start_flow=$flow_array[0];

       $instrument_array=explode(',', $flo->instrument);
       $instrument=$instrument_array[0];
       
        if($resource_type->task_type==1)
       {     

       $forma='';
       $form = ActiveForm::begin(['action'=>['requisitions/create'],]);
       
    

  $forma.="<div style='margin-top:30px; display:block;' class='requisitions-form'>
    <h4 style='color:blue; text-transform:uppercase;'>". ucwords($selected_text)."</h4>";
    
    $forma.=$form->field($model, 'workflow_id')->hiddenInput(['value'=>$flow_id,'id'=>'flowid3'])->label(false).

     $form->field($model, 'status')->hiddenInput(['value'=>$start_flow,'id'=>'status3'])->label(false).

    $form->field($model, 'instrument')->hiddenInput(['value'=>$instrument,'id'=>'instrument3'])->label(false).
    $form->field($model, 'not_seen')->hiddenInput(['value'=>$full_flow,'id'=>'seen3'])->label(false).
    $form->field($model, 'origin')->hiddenInput(['value'=>Yii::$app->user->identity->id,'id'=>'origin3'])->label(false).
    $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid,'id'=>'cid3'])->label(false).
    $form->field($model, 'department')->hiddenInput(['value'=>Yii::$app->user->identity->department,'id'=>'department3'])->label(false).
    $form->field($model, 'title')->hiddenInput(['value'=>'Resource Outflow','id'=>'title3'])->label(false).
    $form->field($model, 'task_type')->hiddenInput(['value'=>$resource_type->task_type,'id'=>'task_type3'])->label(false);


    


$note=json_encode(array('forma'=>$forma,'tag'=>1));
echo $note;

 }
    }

    public function actionChangepass()
    {
      if(Yii::$app->request->post())
      {
        $opass=Yii::$app->request->post('old_password');
        $npass=Yii::$app->request->post('new_password');
        $npassc=Yii::$app->request->post('confirm_new_password');
        // echo $opass; echo $npass; echo $npassc;
        $password=Yii::$app->user->identity->password_hash; 
        $hash=Yii::$app->getSecurity()->generatePasswordHash($npass);
        // echo $password; echo "<br>".$hash; die;
        // $dpass=password_hash($opass,PASSWORD_DEFAULT); echo $dpass; die;
        if(!Yii::$app->getSecurity()->validatePassword($opass,$password))
        {
          die('Your passwords do not match!');
        }
        if($npass!=$npassc)
        {
          die('New passwords do not match!');
        }

        $user=User::findOne(Yii::$app->user->identity->id);
        $user->password_hash=$hash;
        if(!$user->save())
        {
          var_dump($user->getErrors()); die;
        }
        Yii::$app->session->setFlash('success', 'New password saved.');
        return $this->redirect(['changepass']);
        
        
      }
      return $this->render('changepass');
    }

    public function actionLog2()
    {
      $this->layout='Log2';
       $model = new LoginForm();
      return $this->render('log2',['model'=>$model]);
    }

    public function actionLog3()
    {
      $this->layout='Log3';
      return $this->render('log3');
    }

    public function actionReset()
    {
      $model= new User;
      if(Yii::$app->request->post())
      {
        $user=Yii::$app->request->post('user');
        $record=User::findOne($user);
        $npass='555555';
        $record->password_hash=Yii::$app->getSecurity()->generatePasswordHash($npass);
        if($record->save())
        {
          Yii::$app->session->setFlash('success', 'Password has been reset');
          return $this->redirect(['reset']);
        }
      }
      return $this->render('reset',['model'=>$model]);
    }

 
}


