<?php

namespace frontend\modules\retails\controllers;

use Yii;
use frontend\modules\retails\models\Taken;
use frontend\modules\retails\models\TakenSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\modules\retails\models\Rooms2;
use frontend\modules\retails\models\Rooms;
use frontend\modules\retails\models\Inventory;
use frontend\modules\retails\models\Ledger;
use frontend\modules\retails\models\Entry;
use frontend\modules\retails\models\Retails;
use frontend\modules\retails\models\Charts;
use frontend\modules\retails\models\Shifts;
use frontend\modules\retails\models\Reservations;
use frontend\modules\retails\models\Config;
use frontend\modules\retails\models\Banks;


/**
 * TakenController implements the CRUD actions for Taken model.
 */
class TakenController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Taken models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TakenSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Taken model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Taken model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
    $shift=Shifts::find()->where(['shift_name'=>Yii::$app->user->identity->id,'status'=>1])->one();
        if($shift==null){
          die('You do not have an open shift to sell. Please click the back button');
        }


        $model = new Taken();

        if ($model->load(Yii::$app->request->post())) {
        $company=Yii::$app->request->post('account');
        $model->company=$company;

        if($company!=null){
         $purse=\frontend\modules\retails\models\Purse::find()->where(['account'=>$company])->one();
        // if($model->deposit>$purse->amount){
        //   die('Insufficient Purse Balance');
        // }

        // if($purse->amount>0)
        //              {                      
                        // if($purse->amount>=$model->deposit)
                        // {
                          $purse->amount-=$model->deposit;
                        // }                      
                        
                      
                      if(!$purse->save())
                      {
                          // throw new \Exception('could not save to purse' );
                        var_dump($purse->getErrors()); die;
                      }
                     //}

                   }
          


            if($model->complimentary!=2){

            $transaction_id=time().rand(1,9);

            $model->created_at=date('Y-m-d');
            $model->transaction_id=$transaction_id;

            if(!is_numeric($model->departure)){ die('You can only enter numbers for number of days guest is staying. Please go back and enter a number'); }
            
            if($model->complimentary==1)
            {
              
              $model->deposit=0;
              $model->discount=0;
            }

            $rcheck=Rooms2::find()->where(['room_number'=>$model->room_no,'type'=>$model->room_type,'booked'=>1])->one();
            if($rcheck!=null)
            {
                die('Room is already booked to someone else');
            }

            
// echo $model->room_no."- ".$model->room_type; die;
            $check=Rooms2::find()->where(['room_number'=>$model->room_no,'type'=>$model->room_type,'booked'=>0])->one();
           
            $check->booked=1;

            // imported
         

         $start_date=date('Y-m-d');
        $num=$model->departure;
        $new_deal=date('Y-m-d',strtotime($start_date.'+ '.$num.' day'));

            $model->departure=$new_deal;
             $date1=date_create(date('Y-m-d'));
        $date2=date_create(substr($model->departure,0,10));
        $diff=date_diff($date2,$date1);
        $michael=(int)$diff->format("%a");

                           
                                // $michael+=1;

        // set discount to number of days x discount for one day
        $model->discount=$model->discount*$michael;
                            

        $price=Inventory::find()->where(['id'=>$model->room_type])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();


        // run new discount for room based on rate entered
        $model->discount=$price->price-$model->rate;

        // re-calculate total discount for number of days staying
        $model->discount=$model->discount*$michael;
       

        $total=$michael*$price->price;

        $total-=$model->discount;

        if($model->complimentary==1)
        {
          $total=0;
        }


        $details[]=array('shop_id'=>Yii::$app->user->identity->shop_id,'price'=>$price->price,'quantity'=>$michael,'item_name'=>$price->name,'hotel'=>1,'room_no'=>$model->room_no);

        if($model->complimentary==1){
        $details[]=array('shop_id'=>Yii::$app->user->identity->shop_id,'price'=>0,'quantity'=>$michael,'item_name'=>$price->name,'hotel'=>1,'room_no'=>$model->room_no);
      }      



       

            // close imported

            $transaction = Yii::$app->db->beginTransaction();
            try {

            if(!$check->save())
            {
                throw new \Exception('could not save to rooms2');
            }

            if(!$model->save())
            {
                throw new \Exception('could not save to taken');
              // var_dump($model->getErrors()); die;
            }

            // more imported

            $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

            $bank=Banks::findOne($config->bank);
            $bank->balance+=$model->deposit;
            if(!$bank->save())
            {
              throw new \Exception('could not save to taken');
            }



        $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
               if($model->complimentary==1){ $ledger->credit=0; }
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=$transaction_id; 
                if($company==null){
                  $ledger->vendor=(string)$model->guest_id;   
                }else{
                  $ledger->vendor=(string)$company;
                }
                $ledger->amount_paid=$model->deposit;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->bank=$config->bank;
                $ledger->discount=$model->discount;
                $ledger->shift=$shift->shift_id;
                $ledger->payment_method=$model->payment_method;

                $ledger->shift=$shift->shift_id;
                $ledger->stamp=$shift->created_at;
                
               if($model->complimentary==1){ $model->discount=0;}

                if($model->complimentary!=1){
                if(!$ledger->save())
                {
                    
                   throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                }
              }

            // close more imported



                 // start trial balance

        $to_use=Retails::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id,'cid'=>Yii::$app->user->identity->cid])->one();

        $chart_account=$to_use->receivable;
        $chart_account2=$to_use->income_head;


        $ac1=Charts::findOne($to_use->receivable);
        $ac2=Charts::findOne($to_use->income_head);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group; 

        $entry_type=1;


        
      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $total=($total*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $total=($total*-1);
      } 

      $enter = new Entry;
        $enter->amount=$total;
        $enter->entry_type=1;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$ledger->id;
        $enter->dsource='led';
        $enter->transaction_id=$transaction_id;
        $enter->shop_id=Yii::$app->user->identity->shop_id;
        
        if($model->complimentary!=1){
        if(!$enter->save())
        {
          // var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }
      }

        // second entry

        $total=abs($total);
        // entry 2
        $entry_type2=2;
      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $total=($total*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $total=($total*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$total;
        $enter2->entry_type=2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$ledger->id;
        $enter2->dsource='led';
        $enter2->transaction_id=$transaction_id;
        $enter2->shop_id=Yii::$app->user->identity->shop_id;
        if($model->complimentary!=1){
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
      }


        if($model->deposit>0)
        {
        $total=abs($model->deposit);
          $chart_account=$to_use->dbank;
          $chart_account2=$to_use->receivable;


        $ac1=Charts::findOne($chart_account);
        $ac2=Charts::findOne($chart_account2);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group; 

        $entry_type=1;


       
      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $total=($total*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $total=($total*-1);
      } 

      $enter = new Entry;
        $enter->amount=$total;
        $enter->entry_type=1;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$ledger->id;
        $enter->dsource='led';
        $enter->transaction_id=$transaction_id;
        $enter->shop_id=Yii::$app->user->identity->shop_id;
        

        if($model->complimentary!=1){
        if(!$enter->save())
        {
          // var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }
      }

        // second entry

        $total=abs($model->deposit);
        // entry 2
        $entry_type2=2;
      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $total=($total*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $total=($total*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$total;
        $enter2->entry_type=2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$ledger->id;
        $enter2->dsource='led';
        $enter2->transaction_id=$transaction_id;
        $enter2->shop_id=Yii::$app->user->identity->shop_id;

        if($model->complimentary!=1){
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
      }

        }

              // end trial balance

            $transaction->commit();
   
            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; 
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; 
            }

            // return $this->redirect(['view', 'id' => $model->id]);
            return $this->redirect(['/ledger/board']);

          }
			
			// run code for complimentary below here
			
			if($model->complimentary==2) // this is a reservation
      {
        $record=Reservations::find()->where(['id'=>$model->reservation_no])->one();

        $transaction_id=time().rand(1,9);

            $model->created_at=date('Y-m-d');
            $model->transaction_id=$transaction_id;

            if(!is_numeric($model->departure)){ die('You can only enter numbers for number of days guest is staying. Please go back and enter a number'); }
            
           

            $rcheck=Rooms2::find()->where(['room_number'=>$model->room_no,'type'=>$model->room_type,'booked'=>1])->one();
            if($rcheck!=null)
            {
                die('Room is already booked to someone else');
            }

            
// echo $model->room_no."- ".$model->room_type; die;
            $check=Rooms2::find()->where(['room_number'=>$model->room_no,'type'=>$model->room_type,'booked'=>0])->one();
           
            $check->booked=1;

            // imported
         

         $start_date=date('Y-m-d');
        $num=$model->departure;
        $new_deal=date('Y-m-d',strtotime($start_date.'+ '.$num.' day'));

        $model->departure=$new_deal;
        $date1=date_create(date('Y-m-d'));
        $date2=date_create(substr($model->departure,0,10));
        $diff=date_diff($date2,$date1);
        $michael=(int)$diff->format("%a");

                           
                                // $michael+=1;

        // set discount to number of days x discount for one day
        $model->discount=$model->discount*$michael;
                            

        $price=Inventory::find()->where(['id'=>$model->room_type])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();

         // run new discount for room based on rate entered
        $model->discount=$price->price-$model->rate;

        // re-calculate total discount for number of days staying
        $model->discount=$model->discount*$michael;
       

        $total=$michael*$price->price;

        $total-=$model->discount;

        $total-=$model->deposit;
      


        $details[]=array('shop_id'=>Yii::$app->user->identity->shop_id,'price'=>$price->price,'quantity'=>$michael,'item_name'=>$price->name,'hotel'=>1,'room_number'=>$model->room_no);

       


       

            // close imported

            $transaction = Yii::$app->db->beginTransaction();
            try {

            if(!$check->save())
            {
                throw new \Exception('could not save to rooms2');
            }

            if(!$model->save())
            {
                throw new \Exception('could not save to taken');
            }

            // more imported



                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
               if($model->complimentary==1){ $ledger->credit=0; }
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=$transaction_id; 
                if($company==null){
                  $ledger->vendor=(string)$model->guest_id;   
                }else{
                  $ledger->vendor=(string)$company;
                }   
                $ledger->amount_paid=0;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->bank=$config->bank;
                $ledger->discount=$model->discount;
                $ledger->shift=$shift->shift_id;
                $ledger->payment_method=$model->payment_method;
               if($model->complimentary==1){ $model->discount=0;}
               $ledger->reservation_deposit=$model->deposit;

               
                if(!$ledger->save())
                {
                    
                   throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                }
              

            // close more imported



                 // start trial balance

        $to_use=Retails::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id,'cid'=>Yii::$app->user->identity->cid])->one();

        $chart_account=$to_use->receivable;
        $chart_account2=$to_use->income_head;


        $ac1=Charts::findOne($to_use->receivable);
        $ac2=Charts::findOne($to_use->income_head);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group; 

        $entry_type=1;


        
      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $total=($total*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $total=($total*-1);
      } 

      $enter = new Entry;
        $enter->amount=$total;
        $enter->entry_type=1;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$ledger->id;
        $enter->dsource='led';
        $enter->transaction_id=$transaction_id;
        $enter->shop_id=Yii::$app->user->identity->shop_id;
        
 
        if(!$enter->save())
        {
          // var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }
     

        // second entry

        $total=abs($total);
        // entry 2
        $entry_type2=2;
      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $total=($total*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $total=($total*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$total;
        $enter2->entry_type=2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$ledger->id;
        $enter2->dsource='led';
        $enter2->transaction_id=$transaction_id;
        $enter2->shop_id=Yii::$app->user->identity->shop_id;
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
    


      //   if($model->deposit>0)
      //   {
      //   $total=abs($model->deposit);
      //     $chart_account=$to_use->dbank;
      //     $chart_account2=$to_use->receivable;


      //   $ac1=Charts::findOne($chart_account);
      //   $ac2=Charts::findOne($chart_account2);

      //   $entry_group=$ac1->atype;
      //   $entry_group2=$ac2->atype;

      //   $account_group=$ac1->account_group;
      //   $account_group2=$ac2->account_group; 

      //   $entry_type=1;


       
      // if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      // {
      //   $total=($total*-1);
      // }
      // if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      // {
      //   $total=($total*-1);
      // } 

      // $enter = new Entry;
      //   $enter->amount=$total;
      //   $enter->entry_type=1;
      //   $enter->entry_group=$entry_group;
      //   $enter->chart_account=$chart_account;       
        
      //   $enter->account_group=$account_group;
      //   $enter->who=Yii::$app->user->identity->id;
      //   $enter->cid=Yii::$app->user->identity->cid;
      //   $enter->created_at=date('Y-m-d');
      //   $enter->fid=$ledger->id;
      //   $enter->dsource='led';
      //   $enter->transaction_id=$transaction_id;
        

       
      //   if(!$enter->save())
      //   {
      //     var_dump($enter->getErrors()); die;
      //     //throw new \Exception('Could not save entry');
      //   }
    

      //   // second entry

      //   $total=abs($model->deposit);
      //   // entry 2
      //   $entry_type2=2;
      // if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      // {
      //   $total=($total*-1);
      // }
      // if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      // {
      //   $total=($total*-1);
      // }


      //   $enter2 = new Entry;
      //   $enter2->amount=$total;
      //   $enter2->entry_type=2;
      //   $enter2->entry_group=$entry_group2;
      //   $enter2->chart_account=$chart_account2;
    
      //   $enter2->account_group=$account_group2;
      //   $enter2->who=Yii::$app->user->identity->id;
      //   $enter2->cid=Yii::$app->user->identity->cid;
      //   $enter2->created_at=date('Y-m-d');
      //   $enter2->fid=$ledger->id;
      //   $enter2->dsource='led';
      //   $enter2->transaction_id=$transaction_id;

        
      //   if(!$enter2->save())
      //   {
      //     //var_dump($enter2->getErrors()); die;
      //     throw new \Exception('Could not save entry2');
      //   }
 

      //   }

              // end trial balance

            $transaction->commit();
   
            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; 
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; 
            }

            // return $this->redirect(['view', 'id' => $model->id]);
            return $this->redirect(['/ledger/board']);


      }



        }

        // return $this->render('create', [
        //     'model' => $model,
        // ]);

        return $this->redirect(['/ledger/board']);
    }

    /**
     * Updates an existing Taken model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Taken model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die('cannot be done');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Taken model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Taken the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Taken::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
