<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "accounts".
 *
 * @property int $id
 * @property string $company
 * @property string $tel
 * @property string $address
 * @property string $contact_person
 * @property string $email
 * @property int $cid
 */
class Accounts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'accounts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['company', 'tel', 'address', 'contact_person', 'cid'], 'required'],
            [['address'], 'string'],
            [['cid'], 'integer'],
            [['company', 'contact_person'], 'string', 'max' => 255],
            [['tel'], 'string', 'max' => 20],
            [['email'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'company' => 'Company',
            'tel' => 'Tel',
            'address' => 'Address',
            'contact_person' => 'Contact Person',
            'email' => 'Email',
            'cid' => 'Cid',
        ];
    }
}
