<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "auto_legs".
 *
 * @property int $id
 * @property string $name
 * @property int $debit
 * @property int $credit
 * @property int $cid
 * @property string $created_at
 * @property int $leg_type
 */
class AutoLegs extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'auto_legs';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'debit', 'credit', 'leg_type'], 'required'],
            [['debit', 'credit', 'cid', 'leg_type'], 'integer'],
            [['name'], 'string', 'max' => 265],
            [['created_at'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'debit' => 'Debit',
            'credit' => 'Credit',
            'cid' => 'Cid',
            'created_at' => 'Created At',
        ];
    }
}
