<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "batches".
 *
 * @property int $id
 * @property string $items
 * @property double $estimate
 * @property string $product
 * @property int $cid
 * @property string $transaction_id
 * @property string $created_at
 */
class Batches extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'batches';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['items', 'estimate', 'product', 'cid', 'transaction_id'], 'required'],
            [['items'], 'string'],
            [['estimate'], 'number'],
            [['cid'], 'integer'],
            [['created_at'], 'safe'],
            [['product', 'transaction_id'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'items' => 'Items',
            'estimate' => 'Estimate',
            'product' => 'Product',
            'cid' => 'Cid',
            'transaction_id' => 'Transaction ID',
            'created_at' => 'Created At',
        ];
    }
}
