<?php

namespace frontend\modules\retails\models;
use frontend\modules\retails\Inventory;
use Yii;

/**
 * This is the model class for table "boq".
 *
 * @property int $id
 * @property string $product_name
 * @property int $cid
 * @property string $created_at
 * @property string $updated_at
 * @property int $material
 * @property double $estimate
 * @property string $transaction_id
 * @property double $quantity
 */
class Boq extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'boq';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_name', 'cid', 'material', 'estimate', 'transaction_id', 'quantity'], 'required'],
            [['cid', 'material'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['estimate', 'quantity'], 'number'],
            [['product_name', 'transaction_id'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product_name' => 'Product Name',
            'cid' => 'Cid',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'material' => 'Material',
            'estimate' => 'Estimate',
            'transaction_id' => 'Transaction ID',
            'quantity' => 'Quantity',
        ];
    }

       public function getDname()
    {
        $van=Inventory::find()->where(['item_id'=>$this->product_name])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        return $van->name.' - '.$van->description;
    }
}
