<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "categories".
 *
 * @property int $id
 * @property int $cid
 * @property string $category_name
 * @property int $shop_id
 */
class Categories extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'categories';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'category_name'], 'required'],
            [['cid','shop_id'], 'integer'],
            [['category_name'], 'string', 'max' => 225],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'category_name' => 'Category Name',
            'shop_id' => 'Shop ID',
        ];
    }

    public function getUpname()
    {
        return ucwords($this->category_name);
    }
}
