<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "config".
 *
 * @property int $id
 * @property int $cid
 * @property int $bank
 * @property string $company
 * @property int $to_staff
 */
class Config extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'config';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'bank', 'company'], 'required'],
            [['cid', 'bank', 'to_staff'], 'integer'],
            [['company'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'bank' => 'Bank',
            'company' => 'Company',
            'to_staff' => 'To Staff',
        ];
    }
}
