<?php

namespace frontend\modules\retails\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\modules\retails\Entry;

/**
 * EntrySearch represents the model behind the search form of `frontend\models\Entry`.
 */
class EntrySearch extends Entry
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'chart_account', 'entry_type', 'entry_group', 'cid', 'fid', 'account_group', 'who', 'lid', 'shop_id'], 'integer'],
            [['amount'], 'number'],
            [['created_at', 'updated_at', 'dsource', 'transaction_id'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Entry::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'amount' => $this->amount,
            'chart_account' => $this->chart_account,
            'entry_type' => $this->entry_type,
            'entry_group' => $this->entry_group,
            'cid' => $this->cid,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'fid' => $this->fid,
            'account_group' => $this->account_group,
            'who' => $this->who,
            'lid' => $this->lid,
            'shop_id' => $this->shop_id,
        ]);

        $query->andFilterWhere(['like', 'dsource', $this->dsource])
            ->andFilterWhere(['like', 'transaction_id', $this->transaction_id]);

        return $dataProvider;
    }
}
