<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "items".
 *
 * @property int $id
 * @property string $item_name
 * @property double $unit_price
 * @property double $total
 * @property int $req_id
 */
class Items extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'items';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['item_name', 'unit_price', 'total'], 'required'],
            [['unit_price', 'total'], 'number'],
            [['req_id'], 'integer'],
            [['item_name'], 'string', 'max' => 225],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'item_name' => 'Item Name',
            'unit_price' => 'Unit Price',
            'total' => 'Total',
            'req_id' => 'Req ID',
        ];
    }
}
