<?php

namespace frontend\modules\retails\models;

use Yii;


/**
 * This is the model class for table "messages".
 *
 * @property int $id
 * @property int $cid
 * @property string $subject
 * @property string $message
 * @property int $to_id
 * @property int $from_id
 * @property int $status
 * @property string $message_link
 * @property string $added
 * @property string $created_at
 */
class Messages extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'messages';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'subject', 'message', 'to_id', 'from_id', 'message_link'], 'required'],
            [['cid', 'to_id', 'from_id', 'status'], 'integer'],
            [['message'], 'string'],
            [['created_at'], 'safe'],
            [['subject', 'message_link', 'added'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'subject' => 'Subject',
            'message' => 'Message',
            'to_id' => 'To ID',
            'from_id' => 'From ID',
            'status' => 'Status',
            'message_link' => 'Message Link',
            'added' => 'Added',
            'created_at' => 'Created At',
        ];
    }
}
