<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "reservations".
 *
 * @property int $id
 * @property string $contact_person
 * @property string $phone
 * @property int $number_of_rooms
 * @property string $reservation_date
 * @property double $amount_paid
 * @property double $discount
 * @property string $created_at
 * @property int $staff
 * @property int $payment
 * @property int $status
 */
class Reservations extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'reservations';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['contact_person', 'phone', 'number_of_rooms', 'reservation_date', 'staff', 'payment'], 'required'],
            [['number_of_rooms', 'staff', 'payment', 'status'], 'integer'],
            [['reservation_date', 'created_at'], 'safe'],
            [['amount_paid', 'discount'], 'number'],
            [['contact_person'], 'string', 'max' => 255],
            [['phone'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'contact_person' => 'Contact Person',
            'phone' => 'Phone',
            'number_of_rooms' => 'Number Of Rooms',
            'reservation_date' => 'Reservation Date',
            'amount_paid' => 'Amount Paid',
            'discount' => 'Discount',
            'created_at' => 'Created At',
            'staff' => 'Staff',
            'payment' => 'Payment',
            'status' => 'Status',
        ];
    }
}
